/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi;

import com.intellij.lang.jvm.JvmTypeDeclaration;
import com.intellij.lang.jvm.types.JvmReferenceType;
import com.intellij.lang.jvm.types.JvmSubstitutor;
import com.intellij.lang.jvm.types.JvmType;
import com.intellij.lang.jvm.types.JvmTypeResolveResult;
import com.intellij.openapi.util.Comparing;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.JavaResolveResult;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiCapturedWildcardType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiJvmSubstitutor;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiTypeVisitor;
import com.intellij.psi.PsiWildcardType;
import com.intellij.psi.TypeAnnotationProvider;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.ArrayFactory;
import java.util.Arrays;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class PsiClassType
extends PsiType
implements JvmReferenceType {
    public static final PsiClassType[] EMPTY_ARRAY = new PsiClassType[0];
    public static final ArrayFactory<PsiClassType> ARRAY_FACTORY = count -> count == 0 ? EMPTY_ARRAY : new PsiClassType[count];
    protected final LanguageLevel myLanguageLevel;

    protected PsiClassType(@NotNull LanguageLevel languageLevel) {
        this(languageLevel, PsiAnnotation.EMPTY_ARRAY);
    }

    protected PsiClassType(LanguageLevel languageLevel, @NotNull PsiAnnotation[] annotations) {
        super(annotations);
        this.myLanguageLevel = languageLevel;
    }

    public PsiClassType(LanguageLevel languageLevel, @NotNull TypeAnnotationProvider provider) {
        super(provider);
        this.myLanguageLevel = languageLevel;
    }

    @Override
    @NotNull
    public PsiClassType annotate(@NotNull TypeAnnotationProvider provider) {
        return (PsiClassType)super.annotate(provider);
    }

    @Override
    @Nullable
    public abstract PsiClass resolve();

    public abstract String getClassName();

    @NotNull
    public abstract PsiType[] getParameters();

    public int getParameterCount() {
        return this.getParameters().length;
    }

    public boolean equals(Object obj) {
        ClassResolveResult otherResult;
        String otherClassName;
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof PsiClassType)) {
            return obj instanceof PsiCapturedWildcardType && ((PsiCapturedWildcardType)obj).getLowerBound().equalsToText("java.lang.Object") && this.equalsToText("java.lang.Object");
        }
        PsiClassType otherClassType = (PsiClassType)obj;
        String className = this.getClassName();
        if (!Comparing.equal((String)className, (String)(otherClassName = otherClassType.getClassName()))) {
            return false;
        }
        if (this.getParameterCount() != otherClassType.getParameterCount()) {
            return false;
        }
        ClassResolveResult result = this.resolveGenerics();
        if (result == (otherResult = otherClassType.resolveGenerics())) {
            return true;
        }
        PsiClass aClass = result.getElement();
        PsiClass otherClass = otherResult.getElement();
        if (aClass == null || otherClass == null) {
            return aClass == otherClass;
        }
        return aClass.getManager().areElementsEquivalent((PsiElement)aClass, (PsiElement)otherClass) && PsiUtil.equalOnEquivalentClasses(this, aClass, otherClassType, otherClass);
    }

    public boolean hasParameters() {
        ClassResolveResult resolveResult = this.resolveGenerics();
        PsiClass aClass = resolveResult.getElement();
        if (aClass == null) {
            return false;
        }
        boolean hasParams = false;
        for (PsiTypeParameter parameter : PsiUtil.typeParametersIterable(aClass)) {
            if (resolveResult.getSubstitutor().substitute(parameter) == null) {
                return false;
            }
            hasParams = true;
        }
        return hasParams;
    }

    public boolean hasNonTrivialParameters() {
        ClassResolveResult resolveResult = this.resolveGenerics();
        PsiClass aClass = resolveResult.getElement();
        if (aClass == null) {
            return false;
        }
        for (PsiTypeParameter parameter : PsiUtil.typeParametersIterable(aClass)) {
            PsiClass superClass;
            PsiType type = resolveResult.getSubstitutor().substitute(parameter);
            if (type == null) continue;
            if (!(type instanceof PsiWildcardType)) {
                return true;
            }
            PsiType bound = ((PsiWildcardType)type).getBound();
            if (bound == null || ((PsiWildcardType)type).isExtends() && (superClass = parameter.getSuperClass()) != null && PsiUtil.resolveClassInType(bound) == superClass) continue;
            return true;
        }
        return false;
    }

    public int hashCode() {
        String className = this.getClassName();
        if (className == null) {
            return 0;
        }
        return className.hashCode();
    }

    @Override
    @NotNull
    public PsiType[] getSuperTypes() {
        ClassResolveResult resolveResult = this.resolveGenerics();
        PsiClass aClass = resolveResult.getElement();
        if (aClass == null) {
            return EMPTY_ARRAY;
        }
        PsiClassType[] superTypes = aClass.getSuperTypes();
        PsiType[] substitutionResults = PsiClassType.createArray(superTypes.length);
        for (int i = 0; i < superTypes.length; ++i) {
            substitutionResults[i] = resolveResult.getSubstitutor().substitute(superTypes[i]);
        }
        return substitutionResults;
    }

    public static boolean isRaw(ClassResolveResult resolveResult) {
        PsiClass psiClass = resolveResult.getElement();
        return psiClass != null && PsiUtil.isRawSubstitutor(psiClass, resolveResult.getSubstitutor());
    }

    public boolean isRaw() {
        return PsiClassType.isRaw(this.resolveGenerics());
    }

    @NotNull
    public abstract ClassResolveResult resolveGenerics();

    @NotNull
    public abstract PsiClassType rawType();

    @Override
    @NotNull
    public abstract GlobalSearchScope getResolveScope();

    @Override
    public <A> A accept(@NotNull PsiTypeVisitor<A> visitor) {
        return visitor.visitClassType(this);
    }

    @NotNull
    public abstract LanguageLevel getLanguageLevel();

    @NotNull
    @Contract(pure=true)
    public abstract PsiClassType setLanguageLevel(@NotNull LanguageLevel var1);

    @Override
    @NotNull
    public String getName() {
        return this.getClassName();
    }

    @Override
    @Nullable
    public JvmTypeResolveResult resolveType() {
        final ClassResolveResult resolveResult = this.resolveGenerics();
        final PsiClass clazz = resolveResult.getElement();
        return clazz == null ? null : new JvmTypeResolveResult(){
            private final JvmSubstitutor mySubstitutor;
            {
                this.mySubstitutor = new PsiJvmSubstitutor(clazz.getProject(), resolveResult.getSubstitutor());
            }

            @Override
            @NotNull
            public JvmTypeDeclaration getDeclaration() {
                return clazz;
            }

            @Override
            @NotNull
            public JvmSubstitutor getSubstitutor() {
                return this.mySubstitutor;
            }
        };
    }

    @Override
    @NotNull
    public Iterable<JvmType> typeArguments() {
        return Arrays.asList(this.getParameters());
    }

    public static abstract class Stub
    extends PsiClassType {
        protected Stub(LanguageLevel languageLevel, @NotNull PsiAnnotation[] annotations) {
            super(languageLevel, annotations);
        }

        protected Stub(LanguageLevel languageLevel, @NotNull TypeAnnotationProvider annotations) {
            super(languageLevel, annotations);
        }

        @Override
        @NotNull
        public final String getPresentableText() {
            return this.getPresentableText(false);
        }

        @Override
        @NotNull
        public abstract String getPresentableText(boolean var1);

        @Override
        @NotNull
        public final String getCanonicalText() {
            return this.getCanonicalText(false);
        }

        @Override
        @NotNull
        public abstract String getCanonicalText(boolean var1);
    }

    public static interface ClassResolveResult
    extends JavaResolveResult {
        public static final ClassResolveResult EMPTY = new ClassResolveResult(){

            @Override
            public PsiClass getElement() {
                return null;
            }

            @Override
            @NotNull
            public PsiSubstitutor getSubstitutor() {
                return PsiSubstitutor.EMPTY;
            }

            public boolean isValidResult() {
                return false;
            }

            @Override
            public boolean isAccessible() {
                return false;
            }

            @Override
            public boolean isStaticsScopeCorrect() {
                return false;
            }

            @Override
            public PsiElement getCurrentFileResolveScope() {
                return null;
            }

            @Override
            public boolean isPackagePrefixPackageReference() {
                return false;
            }
        };

        public PsiClass getElement();
    }
}

