/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.GenericsUtil;
import com.intellij.psi.PsiIntersectionType;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeVisitor;
import com.intellij.psi.TypeAnnotationProvider;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class PsiDisjunctionType
extends PsiType.Stub {
    private final PsiManager myManager;
    private final List<PsiType> myTypes;
    private final CachedValue<PsiType> myLubCache;

    public PsiDisjunctionType(@NotNull List<PsiType> types, @NotNull PsiManager psiManager) {
        super(TypeAnnotationProvider.EMPTY);
        this.myManager = psiManager;
        this.myTypes = Collections.unmodifiableList(types);
        this.myLubCache = CachedValuesManager.getManager((Project)this.myManager.getProject()).createCachedValue(() -> {
            PsiType lub = this.myTypes.get(0);
            for (int i = 1; i < this.myTypes.size(); ++i) {
                if ((lub = GenericsUtil.getLeastUpperBound(lub, this.myTypes.get(i), this.myManager)) != null) continue;
                lub = PsiType.getJavaLangObject(this.myManager, GlobalSearchScope.allScope((Project)this.myManager.getProject()));
                break;
            }
            return CachedValueProvider.Result.create((Object)lub, (Object[])new Object[]{PsiModificationTracker.OUT_OF_CODE_BLOCK_MODIFICATION_COUNT});
        }, false);
    }

    @NotNull
    public static PsiType createDisjunction(@NotNull List<PsiType> types, @NotNull PsiManager psiManager) {
        assert (!types.isEmpty());
        return types.size() == 1 ? types.get(0) : new PsiDisjunctionType(types, psiManager);
    }

    @NotNull
    public PsiType getLeastUpperBound() {
        return (PsiType)this.myLubCache.getValue();
    }

    @NotNull
    public List<PsiType> getDisjunctions() {
        return this.myTypes;
    }

    @NotNull
    public PsiDisjunctionType newDisjunctionType(List<PsiType> types) {
        return new PsiDisjunctionType(types, this.myManager);
    }

    @Override
    @NotNull
    public String getPresentableText(boolean annotated) {
        return StringUtil.join(this.myTypes, psiType -> psiType.getPresentableText(annotated), (String)" | ");
    }

    @Override
    @NotNull
    public String getCanonicalText(boolean annotated) {
        return StringUtil.join(this.myTypes, psiType -> psiType.getCanonicalText(annotated), (String)" | ");
    }

    @Override
    @NotNull
    public String getInternalCanonicalText() {
        return StringUtil.join(this.myTypes, psiType -> psiType.getInternalCanonicalText(), (String)" | ");
    }

    @Override
    public boolean isValid() {
        for (PsiType type : this.myTypes) {
            if (type.isValid()) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean equalsToText(@NotNull @NonNls String text) {
        return Comparing.equal((String)text, (String)this.getCanonicalText());
    }

    @Override
    public <A> A accept(@NotNull PsiTypeVisitor<A> visitor) {
        return visitor.visitDisjunctionType(this);
    }

    @Override
    public GlobalSearchScope getResolveScope() {
        return this.getLeastUpperBound().getResolveScope();
    }

    @Override
    @NotNull
    public PsiType[] getSuperTypes() {
        PsiType lub = this.getLeastUpperBound();
        if (lub instanceof PsiIntersectionType) {
            return ((PsiIntersectionType)lub).getConjuncts();
        }
        return new PsiType[]{lub};
    }

    public int hashCode() {
        return this.myTypes.get(0).hashCode();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PsiDisjunctionType that = (PsiDisjunctionType)o;
        if (that.myTypes.size() != this.myTypes.size()) {
            return false;
        }
        for (int i = 0; i < this.myTypes.size(); ++i) {
            if (this.myTypes.get(i).equals(that.myTypes.get(i))) continue;
            return false;
        }
        return true;
    }

    public static List<PsiType> flattenAndRemoveDuplicates(@NotNull List<? extends PsiType> types) {
        LinkedHashSet disjunctionSet = new LinkedHashSet();
        for (PsiType psiType : types) {
            PsiDisjunctionType.flatten(disjunctionSet, psiType);
        }
        ArrayList<PsiType> disjunctions = new ArrayList<PsiType>(disjunctionSet);
        Iterator iterator = disjunctions.iterator();
        block1: while (iterator.hasNext()) {
            PsiType d1 = (PsiType)iterator.next();
            for (PsiType d2 : disjunctions) {
                if (d1 == d2 || !d2.isAssignableFrom(d1)) continue;
                iterator.remove();
                continue block1;
            }
        }
        return disjunctions;
    }

    private static void flatten(Set<? super PsiType> disjunctions, PsiType type) {
        if (type instanceof PsiDisjunctionType) {
            for (PsiType child : ((PsiDisjunctionType)type).getDisjunctions()) {
                PsiDisjunctionType.flatten(disjunctions, child);
            }
        } else {
            disjunctions.add(type);
        }
    }
}

