/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi;

import com.intellij.lang.jvm.JvmClassKind;
import com.intellij.lang.jvm.JvmEnumField;
import com.intellij.lang.jvm.JvmModifier;
import com.intellij.lang.jvm.annotation.JvmAnnotationAttributeValue;
import com.intellij.lang.jvm.types.JvmReferenceType;
import com.intellij.openapi.diagnostic.Attachment;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.diagnostic.RuntimeExceptionWithAttachments;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnnotationArrayValue;
import com.intellij.psi.PsiAnnotationClassValue;
import com.intellij.psi.PsiAnnotationConstantValue;
import com.intellij.psi.PsiAnnotationEnumFieldValue;
import com.intellij.psi.PsiAnnotationMemberValue;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiArrayInitializerMemberValue;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassObjectAccessExpression;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiNameValuePair;
import com.intellij.psi.PsiNestedAnnotationValue;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiReferenceList;
import com.intellij.psi.PsiType;
import java.util.Collections;
import java.util.EnumMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class PsiJvmConversionHelper {
    private static final Logger LOG = Logger.getInstance(PsiJvmConversionHelper.class);
    private static final Map<JvmModifier, String> MODIFIERS;

    PsiJvmConversionHelper() {
    }

    @NotNull
    static PsiAnnotation[] getListAnnotations(@NotNull PsiModifierListOwner modifierListOwner) {
        PsiModifierList list = modifierListOwner.getModifierList();
        return list == null ? PsiAnnotation.EMPTY_ARRAY : list.getAnnotations();
    }

    @Nullable
    static PsiAnnotation getListAnnotation(@NotNull PsiModifierListOwner modifierListOwner, @NotNull String fqn) {
        PsiModifierList list = modifierListOwner.getModifierList();
        return list == null ? null : list.findAnnotation(fqn);
    }

    static boolean hasListAnnotation(@NotNull PsiModifierListOwner modifierListOwner, @NotNull String fqn) {
        PsiModifierList list = modifierListOwner.getModifierList();
        return list != null && list.hasAnnotation(fqn);
    }

    static boolean hasListModifier(@NotNull PsiModifierListOwner modifierListOwner, @NotNull JvmModifier modifier) {
        return modifierListOwner.hasModifierProperty(MODIFIERS.get((Object)modifier));
    }

    @NotNull
    static JvmClassKind getJvmClassKind(@NotNull PsiClass psiClass) {
        if (psiClass.isAnnotationType()) {
            return JvmClassKind.ANNOTATION;
        }
        if (psiClass.isInterface()) {
            return JvmClassKind.INTERFACE;
        }
        if (psiClass.isEnum()) {
            return JvmClassKind.ENUM;
        }
        return JvmClassKind.CLASS;
    }

    @Nullable
    static JvmReferenceType getClassSuperType(@NotNull PsiClass psiClass) {
        if (psiClass.isInterface()) {
            return null;
        }
        if (psiClass.isEnum()) {
            return PsiType.getTypeByName("java.lang.Enum", psiClass.getProject(), psiClass.getResolveScope());
        }
        if (psiClass instanceof PsiAnonymousClass) {
            PsiClassType baseClassType = ((PsiAnonymousClass)psiClass).getBaseClassType();
            PsiClass baseClass = baseClassType.resolve();
            if (baseClass == null || !baseClass.isInterface()) {
                return baseClassType;
            }
            return PsiType.getJavaLangObject(psiClass.getManager(), psiClass.getResolveScope());
        }
        if ("java.lang.Object".equals(psiClass.getQualifiedName())) {
            return null;
        }
        PsiClassType[] extendsTypes = psiClass.getExtendsListTypes();
        if (extendsTypes.length != 1) {
            return PsiType.getJavaLangObject(psiClass.getManager(), psiClass.getResolveScope());
        }
        return extendsTypes[0];
    }

    @NotNull
    static JvmReferenceType[] getClassInterfaces(@NotNull PsiClass psiClass) {
        PsiReferenceList referenceList;
        if (psiClass instanceof PsiAnonymousClass) {
            PsiClassType baseClassType = ((PsiAnonymousClass)psiClass).getBaseClassType();
            PsiClass baseClass = baseClassType.resolve();
            if (baseClass != null && baseClass.isInterface()) {
                return new JvmReferenceType[]{baseClassType};
            }
            return JvmReferenceType.EMPTY_ARRAY;
        }
        PsiReferenceList psiReferenceList = referenceList = psiClass.isInterface() ? psiClass.getExtendsList() : psiClass.getImplementsList();
        if (referenceList == null) {
            return JvmReferenceType.EMPTY_ARRAY;
        }
        return referenceList.getReferencedTypes();
    }

    @NotNull
    static String getAnnotationAttributeName(@NotNull PsiNameValuePair pair) {
        String name = pair.getName();
        return name == null ? "value" : name;
    }

    @Nullable
    static JvmAnnotationAttributeValue getAnnotationAttributeValue(@NotNull PsiNameValuePair pair) {
        return PsiJvmConversionHelper.getAnnotationAttributeValue(pair.getValue());
    }

    @Nullable
    static JvmAnnotationAttributeValue getAnnotationAttributeValue(@Nullable PsiAnnotationMemberValue value) {
        PsiElement resolved;
        if (value instanceof PsiClassObjectAccessExpression) {
            return new PsiAnnotationClassValue((PsiClassObjectAccessExpression)value);
        }
        if (value instanceof PsiAnnotation) {
            return new PsiNestedAnnotationValue((PsiAnnotation)value);
        }
        if (value instanceof PsiArrayInitializerMemberValue) {
            return new PsiAnnotationArrayValue((PsiArrayInitializerMemberValue)value);
        }
        if (value instanceof PsiReferenceExpression && (resolved = ((PsiReferenceExpression)value).resolve()) instanceof JvmEnumField) {
            return new PsiAnnotationEnumFieldValue((PsiReferenceExpression)value, (JvmEnumField)resolved);
        }
        if (value instanceof PsiExpression) {
            return new PsiAnnotationConstantValue((PsiExpression)value);
        }
        if (value != null) {
            LOG.warn((Throwable)new RuntimeExceptionWithAttachments("Not implemented: " + value.getClass(), new Attachment[]{new Attachment("text", value.getText())}));
        }
        return null;
    }

    static {
        EnumMap<JvmModifier, String> modifiers = new EnumMap<JvmModifier, String>(JvmModifier.class);
        modifiers.put(JvmModifier.PUBLIC, "public");
        modifiers.put(JvmModifier.PROTECTED, "protected");
        modifiers.put(JvmModifier.PRIVATE, "private");
        modifiers.put(JvmModifier.PACKAGE_LOCAL, "packageLocal");
        modifiers.put(JvmModifier.STATIC, "static");
        modifiers.put(JvmModifier.ABSTRACT, "abstract");
        modifiers.put(JvmModifier.FINAL, "final");
        modifiers.put(JvmModifier.NATIVE, "native");
        modifiers.put(JvmModifier.SYNCHRONIZED, "synchronized");
        modifiers.put(JvmModifier.STRICTFP, "strictfp");
        modifiers.put(JvmModifier.TRANSIENT, "transient");
        modifiers.put(JvmModifier.VOLATILE, "volatile");
        modifiers.put(JvmModifier.TRANSITIVE, "transitive");
        MODIFIERS = Collections.unmodifiableMap(modifiers);
    }
}

