/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.augment;

import com.intellij.diagnostic.PluginException;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class PsiAugmentProvider {
    public static final ExtensionPointName<PsiAugmentProvider> EP_NAME = ExtensionPointName.create((String)"com.intellij.lang.psiAugmentProvider");

    @NotNull
    protected <Psi extends PsiElement> List<Psi> getAugments(@NotNull PsiElement element, @NotNull Class<Psi> type) {
        return Collections.emptyList();
    }

    @Nullable
    protected PsiType inferType(@NotNull PsiTypeElement typeElement) {
        return null;
    }

    @NotNull
    protected Set<String> transformModifiers(@NotNull PsiModifierList modifierList, @NotNull Set<String> modifiers) {
        return modifiers;
    }

    @NotNull
    public static <Psi extends PsiElement> List<Psi> collectAugments(@NotNull PsiElement element, @NotNull Class<? extends Psi> type) {
        List result = ContainerUtil.newSmartList();
        PsiAugmentProvider.forEach(element.getProject(), (Processor<? super PsiAugmentProvider>)((Processor)provider -> {
            result.addAll(provider.getAugments(element, type));
            return true;
        }));
        return result;
    }

    @Nullable
    public static PsiType getInferredType(@NotNull PsiTypeElement typeElement) {
        Ref result = Ref.create();
        PsiAugmentProvider.forEach(typeElement.getProject(), (Processor<? super PsiAugmentProvider>)((Processor)provider -> {
            PsiType type = provider.inferType(typeElement);
            if (type != null) {
                try {
                    PsiUtil.ensureValidType(type);
                }
                catch (ProcessCanceledException e) {
                    throw e;
                }
                catch (Throwable e) {
                    throw PluginException.createByClass((Throwable)e, provider.getClass());
                }
                result.set((Object)type);
                return false;
            }
            return true;
        }));
        return (PsiType)result.get();
    }

    @NotNull
    public static Set<String> transformModifierProperties(@NotNull PsiModifierList modifierList, @NotNull Project project, @NotNull Set<String> modifiers) {
        Ref result = Ref.create(modifiers);
        PsiAugmentProvider.forEach(project, (Processor<? super PsiAugmentProvider>)((Processor)provider -> {
            result.set(provider.transformModifiers(modifierList, Collections.unmodifiableSet((Set)result.get())));
            return true;
        }));
        return (Set)result.get();
    }

    private static void forEach(Project project, Processor<? super PsiAugmentProvider> processor) {
        boolean dumb = DumbService.isDumb((Project)project);
        for (PsiAugmentProvider provider : EP_NAME.getExtensionList()) {
            if (dumb && !DumbService.isDumbAware((Object)provider)) continue;
            try {
                boolean goOn = processor.process((Object)provider);
                if (goOn) continue;
                break;
            }
            catch (ProcessCanceledException e) {
                throw e;
            }
            catch (Exception e) {
                Logger.getInstance(PsiAugmentProvider.class).error("provider: " + provider, (Throwable)e);
            }
        }
    }
}

