/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.search;

import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.ArrayUtil;
import com.intellij.util.CommonProcessors;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.HashSet;
import com.intellij.util.indexing.IdFilter;
import java.util.Collections;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class PsiShortNamesCache {
    public static final ExtensionPointName<PsiShortNamesCache> EP_NAME = ExtensionPointName.create((String)"com.intellij.java.shortNamesCache");

    public static PsiShortNamesCache getInstance(Project project) {
        return (PsiShortNamesCache)ServiceManager.getService((Project)project, PsiShortNamesCache.class);
    }

    @NotNull
    public PsiFile[] getFilesByName(@NotNull String name) {
        return PsiFile.EMPTY_ARRAY;
    }

    @NotNull
    public String[] getAllFileNames() {
        return ArrayUtil.EMPTY_STRING_ARRAY;
    }

    @NotNull
    public abstract PsiClass[] getClassesByName(@NotNull @NonNls String var1, @NotNull GlobalSearchScope var2);

    @NotNull
    public abstract String[] getAllClassNames();

    public boolean processAllClassNames(@NotNull Processor<String> processor) {
        return ContainerUtil.process((Object[])this.getAllClassNames(), processor);
    }

    public boolean processAllClassNames(@NotNull Processor<String> processor, @NotNull GlobalSearchScope scope, @Nullable IdFilter filter2) {
        return ContainerUtil.process((Object[])this.getAllClassNames(), processor);
    }

    @Deprecated
    public void getAllClassNames(@NotNull HashSet<String> dest) {
        this.processAllClassNames((Processor<String>)new CommonProcessors.CollectProcessor(dest));
    }

    @NotNull
    public abstract PsiMethod[] getMethodsByName(@NonNls @NotNull String var1, @NotNull GlobalSearchScope var2);

    @NotNull
    public abstract PsiMethod[] getMethodsByNameIfNotMoreThan(@NonNls @NotNull String var1, @NotNull GlobalSearchScope var2, int var3);

    @NotNull
    public abstract PsiField[] getFieldsByNameIfNotMoreThan(@NonNls @NotNull String var1, @NotNull GlobalSearchScope var2, int var3);

    public abstract boolean processMethodsWithName(@NonNls @NotNull String var1, @NotNull GlobalSearchScope var2, @NotNull Processor<PsiMethod> var3);

    public boolean processMethodsWithName(@NonNls @NotNull String name, @NotNull Processor<? super PsiMethod> processor, @NotNull GlobalSearchScope scope, @Nullable IdFilter filter2) {
        return this.processMethodsWithName(name, scope, (Processor<PsiMethod>)((Processor)method -> processor.process(method)));
    }

    public boolean processAllMethodNames(@NotNull Processor<String> processor, @NotNull GlobalSearchScope scope, @Nullable IdFilter filter2) {
        return ContainerUtil.process((Object[])this.getAllMethodNames(), processor);
    }

    public boolean processAllFieldNames(@NotNull Processor<String> processor, @NotNull GlobalSearchScope scope, @Nullable IdFilter filter2) {
        return ContainerUtil.process((Object[])this.getAllFieldNames(), processor);
    }

    @NotNull
    public abstract String[] getAllMethodNames();

    @Deprecated
    public void getAllMethodNames(@NotNull HashSet<String> set) {
        Collections.addAll(set, this.getAllMethodNames());
    }

    @NotNull
    public abstract PsiField[] getFieldsByName(@NotNull @NonNls String var1, @NotNull GlobalSearchScope var2);

    @NotNull
    public abstract String[] getAllFieldNames();

    @Deprecated
    public void getAllFieldNames(@NotNull HashSet<String> set) {
        Collections.addAll(set, this.getAllFieldNames());
    }

    public boolean processFieldsWithName(@NotNull String name, @NotNull Processor<? super PsiField> processor, @NotNull GlobalSearchScope scope, @Nullable IdFilter filter2) {
        return ContainerUtil.process((Object[])this.getFieldsByName(name, scope), processor);
    }

    public boolean processClassesWithName(@NotNull String name, @NotNull Processor<? super PsiClass> processor, @NotNull GlobalSearchScope scope, @Nullable IdFilter filter2) {
        return ContainerUtil.process((Object[])this.getClassesByName(name, scope), processor);
    }
}

