/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.search.searches;

import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ExtensibleQueryFactory;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.EmptyQuery;
import com.intellij.util.Query;
import com.intellij.util.QueryExecutor;
import org.jetbrains.annotations.NotNull;

public class AllOverridingMethodsSearch
extends ExtensibleQueryFactory<Pair<PsiMethod, PsiMethod>, SearchParameters> {
    public static final ExtensionPointName<QueryExecutor> EP_NAME = ExtensionPointName.create((String)"com.intellij.allOverridingMethodsSearch");
    public static final AllOverridingMethodsSearch INSTANCE = new AllOverridingMethodsSearch();

    private AllOverridingMethodsSearch() {
    }

    @NotNull
    public static Query<Pair<PsiMethod, PsiMethod>> search(@NotNull PsiClass aClass, @NotNull SearchScope scope) {
        if (aClass.hasModifierProperty("final")) {
            return EmptyQuery.getEmptyQuery();
        }
        return INSTANCE.createUniqueResultsQuery(new SearchParameters(aClass, scope));
    }

    @NotNull
    public static Query<Pair<PsiMethod, PsiMethod>> search(@NotNull PsiClass aClass) {
        return AllOverridingMethodsSearch.search(aClass, (SearchScope)GlobalSearchScope.allScope((Project)PsiUtilCore.getProjectInReadAction((PsiElement)aClass)));
    }

    public static class SearchParameters {
        @NotNull
        private final PsiClass myClass;
        @NotNull
        private final SearchScope myScope;

        public SearchParameters(@NotNull PsiClass aClass, @NotNull SearchScope scope) {
            this.myClass = aClass;
            this.myScope = scope;
        }

        @NotNull
        public PsiClass getPsiClass() {
            return this.myClass;
        }

        @NotNull
        public SearchScope getScope() {
            return this.myScope;
        }
    }
}

