/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.search.searches;

import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFunctionalExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ExtensibleQueryFactory;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.EmptyQuery;
import com.intellij.util.Query;
import org.jetbrains.annotations.NotNull;

public class FunctionalExpressionSearch
extends ExtensibleQueryFactory<PsiFunctionalExpression, SearchParameters> {
    public static final FunctionalExpressionSearch INSTANCE = new FunctionalExpressionSearch();

    public static Query<PsiFunctionalExpression> search(@NotNull PsiClass aClass, @NotNull SearchScope scope) {
        return INSTANCE.createUniqueResultsQuery(new SearchParameters(aClass, scope));
    }

    public static Query<PsiFunctionalExpression> search(@NotNull PsiMethod psiMethod) {
        return FunctionalExpressionSearch.search(psiMethod, (SearchScope)GlobalSearchScope.allScope((Project)PsiUtilCore.getProjectInReadAction((PsiElement)psiMethod)));
    }

    public static Query<PsiFunctionalExpression> search(@NotNull PsiMethod psiMethod, @NotNull SearchScope scope) {
        return (Query)ReadAction.compute(() -> {
            PsiClass containingClass;
            if (!psiMethod.hasModifierProperty("static") && !psiMethod.hasModifierProperty("default") && (containingClass = psiMethod.getContainingClass()) != null) {
                return INSTANCE.createUniqueResultsQuery(new SearchParameters(containingClass, scope));
            }
            return EmptyQuery.getEmptyQuery();
        });
    }

    public static Query<PsiFunctionalExpression> search(@NotNull PsiClass aClass) {
        return FunctionalExpressionSearch.search(aClass, (SearchScope)GlobalSearchScope.allScope((Project)PsiUtilCore.getProjectInReadAction((PsiElement)aClass)));
    }

    public static class SearchParameters {
        private final PsiClass myElementToSearch;
        private final SearchScope myScope;

        public SearchParameters(@NotNull PsiClass aClass, @NotNull SearchScope scope) {
            this.myElementToSearch = aClass;
            this.myScope = scope;
        }

        public PsiClass getElementToSearch() {
            return this.myElementToSearch;
        }

        @NotNull
        public SearchScope getEffectiveSearchScope() {
            return this.myScope.intersectWith(this.myElementToSearch.getUseScope());
        }
    }
}

