/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.search.searches;

import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiType;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ExtensibleQueryFactory;
import com.intellij.util.Query;
import org.jetbrains.annotations.NotNull;

public class ImplicitToStringSearch
extends ExtensibleQueryFactory<PsiExpression, SearchParameters> {
    public static final ImplicitToStringSearch INSTANCE = new ImplicitToStringSearch();

    public static Query<PsiExpression> search(@NotNull PsiMethod targetMethod, @NotNull SearchScope scope) {
        return INSTANCE.createUniqueResultsQuery(new SearchParameters(targetMethod, scope));
    }

    public static boolean isToStringMethod(@NotNull PsiElement element) {
        if (!(element instanceof PsiMethod)) {
            return false;
        }
        PsiMethod method = (PsiMethod)element;
        if (!"toString".equals(method.getName())) {
            return false;
        }
        if (method.getParameters().length != 0) {
            return false;
        }
        PsiType returnType = method.getReturnType();
        return returnType != null && returnType.equalsToText("java.lang.String");
    }

    public static class SearchParameters {
        private final PsiMethod myTargetMethod;
        @NotNull
        private final SearchScope myScope;

        public SearchParameters(@NotNull PsiMethod targetMethod, @NotNull SearchScope scope) {
            this.myTargetMethod = targetMethod;
            this.myScope = scope;
        }

        @NotNull
        public PsiMethod getTargetMethod() {
            return this.myTargetMethod;
        }

        @NotNull
        public SearchScope getSearchScope() {
            return this.myScope;
        }
    }
}

