/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.search.searches;

import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ExtensibleQueryFactory;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.EmptyQuery;
import com.intellij.util.Query;
import com.intellij.util.QueryExecutor;
import org.jetbrains.annotations.NotNull;

public class OverridingMethodsSearch
extends ExtensibleQueryFactory<PsiMethod, SearchParameters> {
    public static final ExtensionPointName<QueryExecutor> EP_NAME = ExtensionPointName.create((String)"com.intellij.overridingMethodsSearch");
    public static final OverridingMethodsSearch INSTANCE = new OverridingMethodsSearch();

    private OverridingMethodsSearch() {
    }

    public static Query<PsiMethod> search(@NotNull PsiMethod method, @NotNull SearchScope scope, boolean checkDeep) {
        if (((Boolean)ReadAction.compute(() -> !PsiUtil.canBeOverridden(method))).booleanValue()) {
            return EmptyQuery.getEmptyQuery();
        }
        return INSTANCE.createUniqueResultsQuery(new SearchParameters(method, scope, checkDeep));
    }

    @NotNull
    public static Query<PsiMethod> search(@NotNull PsiMethod method, boolean checkDeep) {
        return OverridingMethodsSearch.search(method, (SearchScope)ReadAction.compute(() -> ((PsiMethod)method).getUseScope()), checkDeep);
    }

    @NotNull
    public static Query<PsiMethod> search(@NotNull PsiMethod method) {
        return OverridingMethodsSearch.search(method, true);
    }

    public static class SearchParameters {
        @NotNull
        private final PsiMethod myMethod;
        @NotNull
        private final SearchScope myScope;
        private final boolean myCheckDeep;

        public SearchParameters(@NotNull PsiMethod method, @NotNull SearchScope scope, boolean checkDeep) {
            this.myMethod = method;
            this.myScope = scope;
            this.myCheckDeep = checkDeep;
        }

        @NotNull
        public PsiMethod getMethod() {
            return this.myMethod;
        }

        public boolean isCheckDeep() {
            return this.myCheckDeep;
        }

        @NotNull
        public SearchScope getScope() {
            return this.myScope;
        }
    }
}

