/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.util;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class FindClassUtil {
    @NotNull
    public static Collection<Module> findModulesWithClass(@NotNull Project project, @NonNls @NotNull String qualifiedName) {
        GlobalSearchScope allScope = GlobalSearchScope.allScope((Project)project);
        JavaPsiFacade facade = JavaPsiFacade.getInstance(project);
        PsiClass[] possibleClasses = facade.findClasses(qualifiedName, allScope);
        if (possibleClasses.length == 0) {
            return Collections.emptyList();
        }
        LinkedHashSet relevantModules = ContainerUtil.newLinkedHashSet();
        ProjectFileIndex fileIndex = ProjectRootManager.getInstance((Project)project).getFileIndex();
        for (PsiClass aClass : possibleClasses) {
            VirtualFile classFile = aClass.getContainingFile().getVirtualFile();
            for (OrderEntry orderEntry : fileIndex.getOrderEntriesForFile(classFile)) {
                relevantModules.add(orderEntry.getOwnerModule());
            }
        }
        return relevantModules;
    }
}

