/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.util;

import com.intellij.diagnostic.PluginException;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.util.MethodSignatureBase;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.TypeConversionUtil;
import org.jetbrains.annotations.NotNull;

public class MethodSignatureBackedByPsiMethod
extends MethodSignatureBase {
    private final PsiMethod myMethod;
    private final boolean myIsRaw;
    private final String myName;

    protected MethodSignatureBackedByPsiMethod(@NotNull PsiMethod method, @NotNull PsiSubstitutor substitutor, boolean isRaw, @NotNull PsiType[] parameterTypes, @NotNull PsiTypeParameter[] methodTypeParameters) {
        super(substitutor, parameterTypes, methodTypeParameters);
        this.myIsRaw = isRaw;
        this.myMethod = method;
        this.myName = method.getName();
    }

    @Override
    @NotNull
    public String getName() {
        return this.myName;
    }

    @Override
    public boolean isRaw() {
        return this.myIsRaw;
    }

    @Override
    public boolean isConstructor() {
        return this.myMethod.isConstructor();
    }

    @Override
    public boolean equals(Object o) {
        if (o instanceof MethodSignatureBackedByPsiMethod && ((MethodSignatureBackedByPsiMethod)o).myMethod == this.myMethod) {
            return true;
        }
        return super.equals(o);
    }

    @NotNull
    public PsiMethod getMethod() {
        return this.myMethod;
    }

    @NotNull
    public static MethodSignatureBackedByPsiMethod create(@NotNull PsiMethod method, @NotNull PsiSubstitutor substitutor) {
        return MethodSignatureBackedByPsiMethod.create(method, substitutor, PsiUtil.isRawSubstitutor(method, substitutor));
    }

    @NotNull
    public static MethodSignatureBackedByPsiMethod create(@NotNull PsiMethod method, @NotNull PsiSubstitutor substitutor, boolean isRaw) {
        PsiTypeParameter[] methodTypeParameters = method.getTypeParameters();
        if (isRaw) {
            substitutor = JavaPsiFacade.getElementFactory(method.getProject()).createRawSubstitutor(substitutor, methodTypeParameters);
            methodTypeParameters = PsiTypeParameter.EMPTY_ARRAY;
        }
        try {
            substitutor.ensureValid();
        }
        catch (ProcessCanceledException e) {
            throw e;
        }
        catch (Throwable e) {
            throw PluginException.createByClass((Throwable)e, method.getClass());
        }
        PsiParameter[] parameters = method.getParameterList().getParameters();
        PsiType[] parameterTypes = PsiType.createArray(parameters.length);
        for (int i = 0; i < parameterTypes.length; ++i) {
            PsiParameter parameter = parameters[i];
            PsiType type = parameter.getType();
            parameterTypes[i] = isRaw ? TypeConversionUtil.erasure(substitutor.substitute(type)) : type;
        }
        return new MethodSignatureBackedByPsiMethod(method, substitutor, isRaw, parameterTypes, methodTypeParameters);
    }
}

