/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.util;

import com.intellij.codeInsight.NullableNotNullManager;
import com.intellij.lang.java.beans.PropertyKind;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.codeStyle.VariableKind;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.ContainerUtil;
import java.beans.Introspector;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PropertyUtilBase {
    @NonNls
    protected static final String GET_PREFIX = PropertyKind.GETTER.prefix;
    @NonNls
    protected static final String IS_PREFIX = PropertyKind.BOOLEAN_GETTER.prefix;
    @NotNull
    protected static final String SET_PREFIX = PropertyKind.SETTER.prefix;

    @Nullable
    public static String getPropertyName(@NonNls @NotNull String methodName) {
        return StringUtil.getPropertyName((String)methodName);
    }

    @NotNull
    public static Map<String, PsiMethod> getAllProperties(@NotNull PsiClass psiClass, boolean acceptSetters, boolean acceptGetters) {
        return PropertyUtilBase.getAllProperties(psiClass, acceptSetters, acceptGetters, true);
    }

    @NotNull
    public static Map<String, PsiMethod> getAllProperties(@NotNull PsiClass psiClass, boolean acceptSetters, boolean acceptGetters, boolean includeSuperClass) {
        return PropertyUtilBase.getAllProperties(acceptSetters, acceptGetters, includeSuperClass ? psiClass.getAllMethods() : psiClass.getMethods());
    }

    @NotNull
    public static Map<String, PsiMethod> getAllProperties(boolean acceptSetters, boolean acceptGetters, PsiMethod[] methods) {
        HashMap<String, PsiMethod> map = new HashMap<String, PsiMethod>();
        for (PsiMethod method : methods) {
            if (PropertyUtilBase.filterMethods(method) || (!acceptSetters || !PropertyUtilBase.isSimplePropertySetter(method)) && (!acceptGetters || !PropertyUtilBase.isSimplePropertyGetter(method))) continue;
            map.put(PropertyUtilBase.getPropertyName(method), method);
        }
        return map;
    }

    private static boolean filterMethods(PsiMethod method) {
        if (method.hasModifierProperty("static") || !method.hasModifierProperty("public")) {
            return true;
        }
        PsiClass psiClass = method.getContainingClass();
        if (psiClass == null) {
            return false;
        }
        String className = psiClass.getQualifiedName();
        return "java.lang.Object".equals(className);
    }

    @NotNull
    public static List<PsiMethod> getSetters(@NotNull PsiClass psiClass, String propertyName) {
        String setterName = PropertyUtilBase.suggestSetterName(propertyName);
        PsiMethod[] psiMethods = psiClass.findMethodsByName(setterName, true);
        ArrayList<PsiMethod> list = new ArrayList<PsiMethod>(psiMethods.length);
        for (PsiMethod method : psiMethods) {
            if (PropertyUtilBase.filterMethods(method) || !PropertyUtilBase.isSimplePropertySetter(method)) continue;
            list.add(method);
        }
        return list;
    }

    @NotNull
    public static List<PsiMethod> getGetters(@NotNull PsiClass psiClass, String propertyName) {
        String[] names = PropertyUtilBase.suggestGetterNames(propertyName);
        ArrayList<PsiMethod> list = new ArrayList<PsiMethod>();
        for (String name : names) {
            PsiMethod[] psiMethods;
            for (PsiMethod method : psiMethods = psiClass.findMethodsByName(name, true)) {
                if (PropertyUtilBase.filterMethods(method) || !PropertyUtilBase.isSimplePropertyGetter(method)) continue;
                list.add(method);
            }
        }
        return list;
    }

    @NotNull
    public static List<PsiMethod> getAccessors(@NotNull PsiClass psiClass, String propertyName) {
        return ContainerUtil.concat(PropertyUtilBase.getGetters(psiClass, propertyName), PropertyUtilBase.getSetters(psiClass, propertyName));
    }

    @NotNull
    public static String[] getReadableProperties(@NotNull PsiClass aClass, boolean includeSuperClass) {
        PsiMethod[] methods;
        ArrayList<String> result = new ArrayList<String>();
        for (PsiMethod method : methods = includeSuperClass ? aClass.getAllMethods() : aClass.getMethods()) {
            if ("java.lang.Object".equals(method.getContainingClass().getQualifiedName()) || !PropertyUtilBase.isSimplePropertyGetter(method)) continue;
            result.add(PropertyUtilBase.getPropertyName(method));
        }
        return ArrayUtil.toStringArray(result);
    }

    @NotNull
    public static String[] getWritableProperties(@NotNull PsiClass aClass, boolean includeSuperClass) {
        PsiMethod[] methods;
        ArrayList<String> result = new ArrayList<String>();
        for (PsiMethod method : methods = includeSuperClass ? aClass.getAllMethods() : aClass.getMethods()) {
            if ("java.lang.Object".equals(method.getContainingClass().getQualifiedName()) || !PropertyUtilBase.isSimplePropertySetter(method)) continue;
            result.add(PropertyUtilBase.getPropertyName(method));
        }
        return ArrayUtil.toStringArray(result);
    }

    @Nullable
    public static PsiType getPropertyType(PsiMember member) {
        if (member instanceof PsiField) {
            return ((PsiField)member).getType();
        }
        if (member instanceof PsiMethod) {
            PsiMethod psiMethod = (PsiMethod)member;
            if (PropertyUtilBase.isSimplePropertyGetter(psiMethod)) {
                return psiMethod.getReturnType();
            }
            if (PropertyUtilBase.isSimplePropertySetter(psiMethod)) {
                return psiMethod.getParameterList().getParameters()[0].getType();
            }
        }
        return null;
    }

    @Nullable
    public static PsiMethod findPropertySetter(PsiClass aClass, @NotNull String propertyName, boolean isStatic, boolean checkSuperClasses) {
        PsiMethod[] methods;
        if (aClass == null) {
            return null;
        }
        String setterName = PropertyUtilBase.suggestSetterName(propertyName);
        for (PsiMethod method : methods = aClass.findMethodsByName(setterName, checkSuperClasses)) {
            if (method.hasModifierProperty("static") != isStatic || !PropertyUtilBase.isSimplePropertySetter(method) || !PropertyUtilBase.getPropertyNameBySetter(method).equals(propertyName)) continue;
            return method;
        }
        return null;
    }

    @Nullable
    public static PsiField findPropertyField(PsiClass aClass, String propertyName, boolean isStatic) {
        PsiField[] fields;
        for (PsiField field : fields = aClass.getAllFields()) {
            if (field.hasModifierProperty("static") != isStatic || !propertyName.equals(PropertyUtilBase.suggestPropertyName(field))) continue;
            return field;
        }
        return null;
    }

    @Nullable
    public static PsiMethod findPropertyGetter(PsiClass aClass, @NotNull String propertyName, boolean isStatic, boolean checkSuperClasses) {
        String[] getterCandidateNames;
        if (aClass == null) {
            return null;
        }
        for (String getterCandidateName : getterCandidateNames = PropertyUtilBase.suggestGetterNames(propertyName)) {
            PsiMethod[] getterCandidates;
            for (PsiMethod method : getterCandidates = aClass.findMethodsByName(getterCandidateName, checkSuperClasses)) {
                if (method.hasModifierProperty("static") != isStatic || !PropertyUtilBase.isSimplePropertyGetter(method) || !PropertyUtilBase.getPropertyNameByGetter(method).equals(propertyName)) continue;
                return method;
            }
        }
        return null;
    }

    @Nullable
    public static PsiMethod findPropertyGetterWithType(String propertyName, boolean isStatic, PsiType type, Iterator<? extends PsiMethod> methods) {
        while (methods.hasNext()) {
            PsiMethod method = methods.next();
            if (method.hasModifierProperty("static") != isStatic || !PropertyUtilBase.isSimplePropertyGetter(method) || !PropertyUtilBase.getPropertyNameByGetter(method).equals(propertyName) || !type.equals(method.getReturnType())) continue;
            return method;
        }
        return null;
    }

    public static boolean isSimplePropertyAccessor(PsiMethod method) {
        return PropertyUtilBase.isSimplePropertyGetter(method) || PropertyUtilBase.isSimplePropertySetter(method);
    }

    @Nullable
    public static PsiMethod findPropertySetterWithType(String propertyName, boolean isStatic, PsiType type, Iterator<? extends PsiMethod> methods) {
        while (methods.hasNext()) {
            PsiType methodType;
            PsiMethod method = methods.next();
            if (method.hasModifierProperty("static") != isStatic || !PropertyUtilBase.isSimplePropertySetter(method) || !PropertyUtilBase.getPropertyNameBySetter(method).equals(propertyName) || !type.equals(methodType = method.getParameterList().getParameters()[0].getType())) continue;
            return method;
        }
        return null;
    }

    @NotNull
    public static GetterFlavour getMethodNameGetterFlavour(@NotNull String methodName) {
        if (PropertyUtilBase.checkPrefix(methodName, GET_PREFIX)) {
            return GetterFlavour.GENERIC;
        }
        if (PropertyUtilBase.checkPrefix(methodName, IS_PREFIX)) {
            return GetterFlavour.BOOLEAN;
        }
        return GetterFlavour.NOT_A_GETTER;
    }

    @Contract(value="null -> false")
    public static boolean isSimplePropertyGetter(@Nullable PsiMethod method) {
        return PropertyUtilBase.hasGetterName(method) && method.getParameterList().isEmpty();
    }

    public static boolean hasGetterName(PsiMethod method) {
        if (method == null) {
            return false;
        }
        if (method.isConstructor()) {
            return false;
        }
        String methodName = method.getName();
        GetterFlavour flavour = PropertyUtilBase.getMethodNameGetterFlavour(methodName);
        switch (flavour) {
            case GENERIC: {
                PsiType returnType = method.getReturnType();
                return returnType == null || !PsiType.VOID.equals(returnType);
            }
            case BOOLEAN: {
                return PropertyUtilBase.isBoolean(method.getReturnType());
            }
        }
        return false;
    }

    private static boolean isBoolean(@Nullable PsiType propertyType) {
        return PsiType.BOOLEAN.equals(propertyType);
    }

    public static String suggestPropertyName(@NotNull PsiField field) {
        return PropertyUtilBase.suggestPropertyName(field, field.getName());
    }

    @NotNull
    public static String suggestPropertyName(@NotNull PsiField field, @NotNull String fieldName) {
        JavaCodeStyleManager codeStyleManager = JavaCodeStyleManager.getInstance(field.getProject());
        VariableKind kind = codeStyleManager.getVariableKind(field);
        String name = codeStyleManager.variableNameToPropertyName(fieldName, kind);
        if (!field.hasModifierProperty("static") && PropertyUtilBase.isBoolean(field.getType()) && name.startsWith(IS_PREFIX) && name.length() > IS_PREFIX.length() && Character.isUpperCase(name.charAt(IS_PREFIX.length()))) {
            name = Introspector.decapitalize(name.substring(IS_PREFIX.length()));
        }
        return name;
    }

    public static String suggestGetterName(PsiField field) {
        String propertyName = PropertyUtilBase.suggestPropertyName(field);
        return PropertyUtilBase.suggestGetterName(propertyName, field.getType());
    }

    public static String suggestSetterName(PsiField field) {
        String propertyName = PropertyUtilBase.suggestPropertyName(field);
        return PropertyUtilBase.suggestSetterName(propertyName);
    }

    @Nullable
    public static String getPropertyName(PsiMember member) {
        if (member instanceof PsiMethod) {
            return PropertyUtilBase.getPropertyName((PsiMethod)member);
        }
        if (member instanceof PsiField) {
            return member.getName();
        }
        return null;
    }

    public static boolean isSimplePropertySetter(@Nullable PsiMethod method) {
        if (method == null) {
            return false;
        }
        if (method.isConstructor()) {
            return false;
        }
        String methodName = method.getName();
        if (!PropertyUtilBase.isSetterName(methodName)) {
            return false;
        }
        if (method.getParameterList().getParametersCount() != 1) {
            return false;
        }
        PsiType returnType = method.getReturnType();
        if (returnType == null || PsiType.VOID.equals(returnType)) {
            return true;
        }
        return Comparing.equal((Object)PsiUtil.resolveClassInType(TypeConversionUtil.erasure(returnType)), (Object)method.getContainingClass());
    }

    public static boolean isSetterName(@NotNull String methodName) {
        return PropertyUtilBase.checkPrefix(methodName, SET_PREFIX);
    }

    @Nullable
    public static String getPropertyName(@NotNull PsiMethod method) {
        if (PropertyUtilBase.isSimplePropertyGetter(method)) {
            return PropertyUtilBase.getPropertyNameByGetter(method);
        }
        if (PropertyUtilBase.isSimplePropertySetter(method)) {
            return PropertyUtilBase.getPropertyNameBySetter(method);
        }
        return null;
    }

    @NotNull
    public static String getPropertyNameByGetter(PsiMethod getterMethod) {
        String methodName = getterMethod.getName();
        if (methodName.startsWith(GET_PREFIX)) {
            return StringUtil.decapitalize((String)methodName.substring(3));
        }
        if (methodName.startsWith(IS_PREFIX)) {
            return StringUtil.decapitalize((String)methodName.substring(2));
        }
        return methodName;
    }

    @NotNull
    public static String getPropertyNameBySetter(@NotNull PsiMethod setterMethod) {
        String methodName = setterMethod.getName();
        return Introspector.decapitalize(methodName.substring(3));
    }

    private static boolean checkPrefix(@NotNull String methodName, @NotNull String prefix) {
        boolean hasPrefix = methodName.startsWith(prefix) && methodName.length() > prefix.length();
        return hasPrefix && (!Character.isLowerCase(methodName.charAt(prefix.length())) || methodName.length() != prefix.length() + 1 && !Character.isLowerCase(methodName.charAt(prefix.length() + 1)));
    }

    @NonNls
    @NotNull
    public static String[] suggestGetterNames(@NotNull String propertyName) {
        String str = StringUtil.capitalizeWithJavaBeanConvention((String)StringUtil.sanitizeJavaIdentifier((String)propertyName));
        return new String[]{IS_PREFIX + str, GET_PREFIX + str};
    }

    public static String suggestGetterName(@NonNls @NotNull String propertyName, @Nullable PsiType propertyType) {
        return PropertyUtilBase.suggestGetterName(propertyName, propertyType, null);
    }

    public static String suggestGetterName(@NotNull String propertyName, @Nullable PsiType propertyType, @NonNls String existingGetterName) {
        StringBuilder name = new StringBuilder(StringUtil.capitalizeWithJavaBeanConvention((String)StringUtil.sanitizeJavaIdentifier((String)propertyName)));
        if (PropertyUtilBase.isBoolean(propertyType)) {
            if (existingGetterName == null || !existingGetterName.startsWith(GET_PREFIX)) {
                name.insert(0, IS_PREFIX);
            } else {
                name.insert(0, GET_PREFIX);
            }
        } else {
            name.insert(0, GET_PREFIX);
        }
        return name.toString();
    }

    public static String suggestSetterName(@NonNls @NotNull String propertyName) {
        return PropertyUtilBase.suggestSetterName(propertyName, SET_PREFIX);
    }

    public static String suggestSetterName(@NonNls @NotNull String propertyName, String setterPrefix) {
        String sanitizeJavaIdentifier = StringUtil.sanitizeJavaIdentifier((String)propertyName);
        if (StringUtil.isEmpty((String)setterPrefix)) {
            return sanitizeJavaIdentifier;
        }
        StringBuilder name = new StringBuilder(StringUtil.capitalizeWithJavaBeanConvention((String)sanitizeJavaIdentifier));
        name.insert(0, setterPrefix);
        return name.toString();
    }

    @NotNull
    public static PsiMethod generateGetterPrototype(@NotNull PsiField field) {
        PsiElementFactory factory = JavaPsiFacade.getElementFactory(field.getProject());
        Project project = field.getProject();
        String name = field.getName();
        String getName = PropertyUtilBase.suggestGetterName(field);
        PsiMethod getMethod = factory.createMethod(getName, field.getType());
        PsiUtil.setModifierProperty(getMethod, "public", true);
        if (field.hasModifierProperty("static")) {
            PsiUtil.setModifierProperty(getMethod, "static", true);
        }
        NullableNotNullManager.getInstance(project).copyNullableOrNotNullAnnotation(field, getMethod);
        PsiCodeBlock body = factory.createCodeBlockFromText("{\nreturn " + name + ";\n}", null);
        Objects.requireNonNull(getMethod.getBody()).replace(body);
        getMethod = (PsiMethod)CodeStyleManager.getInstance((Project)project).reformat((PsiElement)getMethod);
        return getMethod;
    }

    @NotNull
    public static PsiMethod generateSetterPrototype(@NotNull PsiField field) {
        return PropertyUtilBase.generateSetterPrototype(field, field.getContainingClass());
    }

    @NotNull
    public static PsiMethod generateSetterPrototype(@NotNull PsiField field, @NotNull PsiClass containingClass) {
        return PropertyUtilBase.generateSetterPrototype(field, containingClass, false);
    }

    @NotNull
    public static PsiMethod generateSetterPrototype(@NotNull PsiField field, @NotNull PsiClass containingClass, boolean returnSelf) {
        Project project = field.getProject();
        JavaCodeStyleManager codeStyleManager = JavaCodeStyleManager.getInstance(project);
        PsiElementFactory factory = JavaPsiFacade.getElementFactory(field.getProject());
        String name = field.getName();
        boolean isStatic = field.hasModifierProperty("static");
        VariableKind kind = codeStyleManager.getVariableKind(field);
        String propertyName = codeStyleManager.variableNameToPropertyName(name, kind);
        String setName = PropertyUtilBase.suggestSetterName(field);
        PsiMethod setMethod = factory.createMethodFromText(factory.createMethod(setName, returnSelf ? factory.createType(containingClass) : PsiType.VOID).getText(), field);
        String parameterName = codeStyleManager.propertyNameToVariableName(propertyName, VariableKind.PARAMETER);
        PsiParameter param = factory.createParameter(parameterName, field.getType());
        NullableNotNullManager.getInstance(project).copyNullableOrNotNullAnnotation(field, param);
        setMethod.getParameterList().add(param);
        PsiUtil.setModifierProperty(setMethod, "public", true);
        PsiUtil.setModifierProperty(setMethod, "static", isStatic);
        StringBuilder buffer = new StringBuilder();
        buffer.append("{\n");
        if (name.equals(parameterName)) {
            if (!isStatic) {
                buffer.append("this.");
            } else {
                String className = containingClass.getName();
                if (className != null) {
                    buffer.append(className);
                    buffer.append(".");
                }
            }
        }
        buffer.append(name);
        buffer.append("=");
        buffer.append(parameterName);
        buffer.append(";\n");
        if (returnSelf) {
            buffer.append("return this;\n");
        }
        buffer.append("}");
        PsiCodeBlock body = factory.createCodeBlockFromText(buffer.toString(), null);
        Objects.requireNonNull(setMethod.getBody()).replace(body);
        setMethod = (PsiMethod)CodeStyleManager.getInstance((Project)project).reformat((PsiElement)setMethod);
        return setMethod;
    }

    @Nullable
    public static PsiTypeElement getPropertyTypeElement(PsiMember member) {
        if (member instanceof PsiField) {
            return ((PsiField)member).getTypeElement();
        }
        if (member instanceof PsiMethod) {
            PsiMethod psiMethod = (PsiMethod)member;
            if (PropertyUtilBase.isSimplePropertyGetter(psiMethod)) {
                return psiMethod.getReturnTypeElement();
            }
            if (PropertyUtilBase.isSimplePropertySetter(psiMethod)) {
                return psiMethod.getParameterList().getParameters()[0].getTypeElement();
            }
        }
        return null;
    }

    @Nullable
    public static PsiIdentifier getPropertyNameIdentifier(PsiMember member) {
        if (member instanceof PsiField) {
            return ((PsiField)member).getNameIdentifier();
        }
        if (member instanceof PsiMethod) {
            return ((PsiMethod)member).getNameIdentifier();
        }
        return null;
    }

    @Nullable
    public static PsiField findPropertyFieldByMember(PsiMember psiMember) {
        if (psiMember instanceof PsiField) {
            return (PsiField)psiMember;
        }
        if (psiMember instanceof PsiMethod) {
            PsiElement resolved;
            PsiExpression target;
            PsiStatement statement;
            PsiMethod psiMethod = (PsiMethod)psiMember;
            PsiType returnType = psiMethod.getReturnType();
            if (returnType == null) {
                return null;
            }
            PsiCodeBlock body = psiMethod.getBody();
            PsiStatement[] statements = body == null ? null : body.getStatements();
            PsiStatement psiStatement = statement = statements == null || statements.length != 1 ? null : statements[0];
            if (PsiType.VOID.equals(returnType)) {
                PsiExpression expression = statement instanceof PsiExpressionStatement ? ((PsiExpressionStatement)statement).getExpression() : null;
                target = expression instanceof PsiAssignmentExpression ? ((PsiAssignmentExpression)expression).getLExpression() : null;
            } else {
                target = statement instanceof PsiReturnStatement ? ((PsiReturnStatement)statement).getReturnValue() : null;
            }
            PsiElement psiElement = resolved = target instanceof PsiReferenceExpression ? ((PsiReferenceExpression)target).resolve() : null;
            if (resolved instanceof PsiField) {
                PsiField field = (PsiField)resolved;
                PsiClass memberClass = psiMember.getContainingClass();
                PsiClass fieldClass = field.getContainingClass();
                if (memberClass != null && fieldClass != null && (memberClass == fieldClass || memberClass.isInheritor(fieldClass, true))) {
                    return field;
                }
            }
        }
        return null;
    }

    public static PsiMethod findSetterForField(PsiField field) {
        PsiClass containingClass = field.getContainingClass();
        String propertyName = PropertyUtilBase.suggestPropertyName(field);
        boolean isStatic = field.hasModifierProperty("static");
        return PropertyUtilBase.findPropertySetter(containingClass, propertyName, isStatic, true);
    }

    public static PsiMethod findGetterForField(PsiField field) {
        PsiClass containingClass = field.getContainingClass();
        String propertyName = PropertyUtilBase.suggestPropertyName(field);
        boolean isStatic = field.hasModifierProperty("static");
        return PropertyUtilBase.findPropertyGetter(containingClass, propertyName, isStatic, true);
    }

    @Nullable
    public static PsiExpression getGetterReturnExpression(@Nullable PsiMethod method) {
        return method != null && PropertyUtilBase.hasGetterSignature(method) ? PropertyUtilBase.getSingleReturnValue(method) : null;
    }

    private static boolean hasGetterSignature(@NotNull PsiMethod method) {
        return PropertyUtilBase.isSimplePropertyGetter(method);
    }

    @Nullable
    public static PsiExpression getSingleReturnValue(@NotNull PsiMethod method) {
        PsiCodeBlock body = method.getBody();
        if (body == null) {
            return null;
        }
        PsiStatement[] statements = body.getStatements();
        PsiStatement statement = statements.length != 1 ? null : statements[0];
        return statement instanceof PsiReturnStatement ? ((PsiReturnStatement)statement).getReturnValue() : null;
    }

    @Contract(pure=true)
    @Nullable
    public static PropertyKind getPropertyKind(@NotNull String accessorName) {
        for (PropertyKind kind : PropertyKind.values()) {
            String prefix = kind.prefix;
            int prefixLength = prefix.length();
            if (!accessorName.startsWith(prefix) || accessorName.length() <= prefixLength) continue;
            return kind;
        }
        return null;
    }

    @Contract(pure=true)
    @Nullable
    public static Pair<String, PropertyKind> getPropertyNameAndKind(@NotNull String accessorName) {
        PropertyKind kind = PropertyUtilBase.getPropertyKind(accessorName);
        if (kind == null) {
            return null;
        }
        String baseName = accessorName.substring(kind.prefix.length());
        String propertyName = Introspector.decapitalize(baseName);
        return Pair.create((Object)propertyName, (Object)((Object)kind));
    }

    @Contract(pure=true)
    @NotNull
    public static String getAccessorName(@NotNull String propertyName, @NotNull PropertyKind kind) {
        return kind.prefix + StringUtil.capitalizeWithJavaBeanConvention((String)propertyName);
    }

    public static enum GetterFlavour {
        BOOLEAN,
        GENERIC,
        NOT_A_GETTER;

    }
}

