/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.util;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiBundle;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiDeclarationStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiEllipsisType;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifier;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiReferenceList;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiTypeParameterListOwner;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.util.ClassUtil;
import com.intellij.psi.util.PsiExpressionTrimRenderer;
import com.intellij.psi.util.PsiFormatUtilBase;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.util.BitUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.VisibilityUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PsiFormatUtil
extends PsiFormatUtilBase {
    public static String formatVariable(@NotNull PsiVariable variable, @FormatVariableOptions int options, PsiSubstitutor substitutor) {
        StringBuilder buffer = new StringBuilder();
        PsiFormatUtil.formatVariable(variable, options, substitutor, buffer);
        return buffer.toString();
    }

    private static void formatVariable(@NotNull PsiVariable variable, @FormatVariableOptions int options, PsiSubstitutor substitutor, @NotNull StringBuilder buffer) {
        PsiExpression initializer;
        String name;
        if (BitUtil.isSet((int)options, (int)8) && !BitUtil.isSet((int)options, (int)16)) {
            PsiFormatUtil.formatModifiers(variable, options, buffer);
        }
        if (BitUtil.isSet((int)options, (int)2) && !BitUtil.isSet((int)options, (int)4)) {
            PsiFormatUtil.appendSpaceIfNeeded((StringBuilder)buffer);
            buffer.append(PsiFormatUtil.formatType(variable.getType(), options, substitutor));
        }
        if (variable instanceof PsiField && BitUtil.isSet((int)options, (int)4096)) {
            String className;
            PsiClass aClass = ((PsiField)variable).getContainingClass();
            if (aClass != null && (className = aClass.getName()) != null) {
                PsiFormatUtil.appendSpaceIfNeeded((StringBuilder)buffer);
                if (BitUtil.isSet((int)options, (int)2048)) {
                    buffer.append((String)ObjectUtils.notNull((Object)aClass.getQualifiedName(), (Object)className));
                } else {
                    buffer.append(className);
                }
                buffer.append('.');
            }
            if (BitUtil.isSet((int)options, (int)1)) {
                buffer.append(variable.getName());
            }
        } else if (BitUtil.isSet((int)options, (int)1) && StringUtil.isNotEmpty((String)(name = variable.getName()))) {
            PsiFormatUtil.appendSpaceIfNeeded((StringBuilder)buffer);
            buffer.append(name);
        }
        if (BitUtil.isSet((int)options, (int)2) && BitUtil.isSet((int)options, (int)4)) {
            if (BitUtil.isSet((int)options, (int)1) && variable.getName() != null) {
                buffer.append(':');
            }
            buffer.append(PsiFormatUtil.formatType(variable.getType(), options, substitutor));
        }
        if (BitUtil.isSet((int)options, (int)8) && BitUtil.isSet((int)options, (int)16)) {
            PsiFormatUtil.formatModifiers(variable, options, buffer);
        }
        if (BitUtil.isSet((int)options, (int)128) && (initializer = variable.getInitializer()) != null) {
            int index2;
            buffer.append(" = ");
            String text = PsiExpressionTrimRenderer.render(initializer);
            int index1 = text.lastIndexOf(10);
            if (index1 < 0) {
                index1 = text.length();
            }
            if ((index2 = text.lastIndexOf(13)) < 0) {
                index2 = text.length();
            }
            int index = Math.min(index1, index2);
            buffer.append(text, 0, index);
            if (index < text.length()) {
                buffer.append(" ...");
            }
        }
    }

    public static String formatMethod(@NotNull PsiMethod method, @NotNull PsiSubstitutor substitutor, @FormatMethodOptions int options, @FormatVariableOptions int parameterOptions) {
        return PsiFormatUtil.formatMethod(method, substitutor, options, parameterOptions, 7);
    }

    public static String formatMethod(@NotNull PsiMethod method, @NotNull PsiSubstitutor substitutor, @FormatMethodOptions int options, @FormatVariableOptions int parameterOptions, int maxParametersToShow) {
        StringBuilder buffer = new StringBuilder();
        PsiFormatUtil.formatMethod(method, substitutor, options, parameterOptions, maxParametersToShow, buffer);
        return buffer.toString();
    }

    private static void formatMethod(@NotNull PsiMethod method, @NotNull PsiSubstitutor substitutor, @FormatMethodOptions int options, @FormatVariableOptions int parameterOptions, int maxParametersToShow, StringBuilder buffer) {
        String throwsText;
        PsiType type;
        if (BitUtil.isSet((int)options, (int)8) && !BitUtil.isSet((int)options, (int)16)) {
            PsiFormatUtil.formatModifiers(method, options, buffer);
        }
        if (BitUtil.isSet((int)options, (int)2) && !BitUtil.isSet((int)options, (int)4) && (type = method.getReturnType()) != null) {
            PsiFormatUtil.appendSpaceIfNeeded((StringBuilder)buffer);
            buffer.append(PsiFormatUtil.formatType(type, options, substitutor));
        }
        if (BitUtil.isSet((int)options, (int)4096)) {
            PsiClass aClass = method.getContainingClass();
            if (aClass != null) {
                PsiFormatUtil.appendSpaceIfNeeded((StringBuilder)buffer);
                String name = aClass.getName();
                if (name != null) {
                    if (BitUtil.isSet((int)options, (int)2048)) {
                        buffer.append((String)ObjectUtils.notNull((Object)aClass.getQualifiedName(), (Object)name));
                    } else {
                        buffer.append(name);
                    }
                    buffer.append('.');
                }
            }
            if (BitUtil.isSet((int)options, (int)1)) {
                buffer.append(method.getName());
            }
        } else if (BitUtil.isSet((int)options, (int)1)) {
            PsiFormatUtil.appendSpaceIfNeeded((StringBuilder)buffer);
            buffer.append(method.getName());
        }
        if (BitUtil.isSet((int)options, (int)256)) {
            buffer.append('(');
            PsiParameter[] params = method.getParameterList().getParameters();
            for (int i = 0; i < Math.min(params.length, maxParametersToShow); ++i) {
                if (i > 0) {
                    buffer.append(", ");
                }
                buffer.append(PsiFormatUtil.formatVariable(params[i], parameterOptions, substitutor));
            }
            if (params.length > maxParametersToShow) {
                buffer.append(", ...");
            }
            buffer.append(')');
        }
        if (BitUtil.isSet((int)options, (int)2) && BitUtil.isSet((int)options, (int)4) && (type = method.getReturnType()) != null) {
            if (buffer.length() > 0) {
                buffer.append(':');
            }
            buffer.append(PsiFormatUtil.formatType(type, options, substitutor));
        }
        if (BitUtil.isSet((int)options, (int)8) && BitUtil.isSet((int)options, (int)16)) {
            PsiFormatUtil.formatModifiers(method, options, buffer);
        }
        if (BitUtil.isSet((int)options, (int)512) && !(throwsText = PsiFormatUtil.formatReferenceList(method.getThrowsList(), options)).isEmpty()) {
            PsiFormatUtil.appendSpaceIfNeeded((StringBuilder)buffer);
            buffer.append("throws ").append(throwsText);
        }
    }

    @NotNull
    public static String formatClass(@NotNull PsiClass aClass, @FormatClassOptions int options) {
        StringBuilder buffer = new StringBuilder();
        if (BitUtil.isSet((int)options, (int)8) && !BitUtil.isSet((int)options, (int)16)) {
            PsiFormatUtil.formatModifiers(aClass, options, buffer);
        }
        if (BitUtil.isSet((int)options, (int)1)) {
            if (aClass instanceof PsiAnonymousClass && BitUtil.isSet((int)options, (int)32768)) {
                PsiClassType baseClassReference = ((PsiAnonymousClass)aClass).getBaseClassType();
                PsiClass baseClass = baseClassReference.resolve();
                String name = baseClass == null ? baseClassReference.getPresentableText() : PsiFormatUtil.formatClass(baseClass, options);
                buffer.append(PsiBundle.message((String)"anonymous.class.derived.display", (Object[])new Object[]{name}));
            } else {
                String name = aClass.getName();
                if (name != null) {
                    PsiFormatUtil.appendSpaceIfNeeded((StringBuilder)buffer);
                    if (BitUtil.isSet((int)options, (int)2048)) {
                        String qName = aClass.getQualifiedName();
                        if (qName != null) {
                            buffer.append(qName);
                        } else {
                            buffer.append(aClass.getName());
                        }
                    } else {
                        buffer.append(aClass.getName());
                    }
                }
            }
        }
        if (BitUtil.isSet((int)options, (int)8) && BitUtil.isSet((int)options, (int)16)) {
            PsiFormatUtil.formatModifiers(aClass, options, buffer);
        }
        if (BitUtil.isSet((int)options, (int)1024)) {
            String implementsText;
            PsiReferenceList implementsList;
            String extendsText;
            PsiReferenceList extendsList = aClass.getExtendsList();
            if (extendsList != null && !(extendsText = PsiFormatUtil.formatReferenceList(extendsList, options)).isEmpty()) {
                PsiFormatUtil.appendSpaceIfNeeded((StringBuilder)buffer);
                buffer.append("extends ").append(extendsText);
            }
            if ((implementsList = aClass.getImplementsList()) != null && !(implementsText = PsiFormatUtil.formatReferenceList(implementsList, options)).isEmpty()) {
                PsiFormatUtil.appendSpaceIfNeeded((StringBuilder)buffer);
                buffer.append("implements ").append(implementsText);
            }
        }
        return buffer.toString();
    }

    @NotNull
    public static String formatModifiers(@NotNull PsiModifierListOwner element, int options) {
        StringBuilder buffer = new StringBuilder();
        PsiFormatUtil.formatModifiers(element, options, buffer);
        return buffer.toString();
    }

    private static void formatModifiers(PsiModifierListOwner element, int options, StringBuilder buffer) {
        boolean isInterface;
        PsiModifierList list = element.getModifierList();
        if (list == null) {
            return;
        }
        if (!BitUtil.isSet((int)options, (int)32) ? list.hasExplicitModifier("public") : list.hasModifierProperty("public")) {
            PsiFormatUtil.appendModifier(buffer, "public");
        }
        if (list.hasModifierProperty("protected")) {
            PsiFormatUtil.appendModifier(buffer, "protected");
        }
        if (list.hasModifierProperty("private")) {
            PsiFormatUtil.appendModifier(buffer, "private");
        }
        if (!BitUtil.isSet((int)options, (int)32) ? list.hasExplicitModifier("packageLocal") : list.hasModifierProperty("packageLocal")) {
            if (element instanceof PsiClass && element.getParent() instanceof PsiDeclarationStatement) {
                PsiFormatUtil.append(buffer, PsiBundle.message((String)"local.class.preposition", (Object[])new Object[0]));
            } else {
                PsiFormatUtil.appendModifier(buffer, "packageLocal");
            }
        }
        if (!BitUtil.isSet((int)options, (int)32) ? list.hasExplicitModifier("static") : list.hasModifierProperty("static")) {
            PsiFormatUtil.appendModifier(buffer, "static");
        }
        boolean bl = isInterface = element instanceof PsiClass && ((PsiClass)element).isInterface();
        if (!isInterface && (!BitUtil.isSet((int)options, (int)32) ? list.hasExplicitModifier("abstract") : list.hasModifierProperty("abstract"))) {
            PsiFormatUtil.appendModifier(buffer, "abstract");
        }
        if (!BitUtil.isSet((int)options, (int)32) ? list.hasExplicitModifier("final") : list.hasModifierProperty("final")) {
            PsiFormatUtil.appendModifier(buffer, "final");
        }
        if (list.hasModifierProperty("native") && !BitUtil.isSet((int)options, (int)16384)) {
            PsiFormatUtil.appendModifier(buffer, "native");
        }
        if (list.hasModifierProperty("synchronized") && !BitUtil.isSet((int)options, (int)16384)) {
            PsiFormatUtil.appendModifier(buffer, "synchronized");
        }
        if (list.hasModifierProperty("strictfp") && !BitUtil.isSet((int)options, (int)16384)) {
            PsiFormatUtil.appendModifier(buffer, "strictfp");
        }
        if (list.hasModifierProperty("transient") && element instanceof PsiVariable) {
            PsiFormatUtil.appendModifier(buffer, "transient");
        }
        if (list.hasModifierProperty("volatile")) {
            PsiFormatUtil.appendModifier(buffer, "volatile");
        }
    }

    private static void appendModifier(StringBuilder buffer, @PsiModifier.ModifierConstant @NotNull String modifier) {
        PsiFormatUtil.append(buffer, VisibilityUtil.toPresentableText(modifier));
    }

    private static void append(StringBuilder buffer, String modifier) {
        PsiFormatUtil.appendSpaceIfNeeded((StringBuilder)buffer);
        buffer.append(modifier);
    }

    private static String formatReferenceList(PsiReferenceList list, int options) {
        StringBuilder buffer = new StringBuilder();
        if (BitUtil.isSet((int)options, (int)65536)) {
            PsiClassType[] types = list.getReferencedTypes();
            for (int i = 0; i < types.length; ++i) {
                if (i > 0) {
                    buffer.append(", ");
                }
                buffer.append(PsiFormatUtil.formatType(types[i], options, PsiSubstitutor.EMPTY));
            }
        } else {
            PsiJavaCodeReferenceElement[] refs = list.getReferenceElements();
            for (int i = 0; i < refs.length; ++i) {
                if (i > 0) {
                    buffer.append(", ");
                }
                buffer.append(PsiFormatUtil.formatReference(refs[i], options));
            }
        }
        return buffer.toString();
    }

    public static String formatType(@Nullable PsiType type, int options, @NotNull PsiSubstitutor substitutor) {
        type = substitutor.substitute(type);
        if (BitUtil.isSet((int)options, (int)65536)) {
            type = TypeConversionUtil.erasure(type);
        } else if (BitUtil.isSet((int)options, (int)131072) && !(PsiUtil.resolveClassInType(type) instanceof PsiTypeParameter)) {
            boolean preserveEllipsis = type instanceof PsiEllipsisType;
            type = TypeConversionUtil.erasure(type);
            if (preserveEllipsis && type instanceof PsiArrayType) {
                type = new PsiEllipsisType(((PsiArrayType)type).getComponentType());
            }
        }
        if (type == null) {
            return "null";
        }
        return !BitUtil.isSet((int)options, (int)8192) ? type.getPresentableText(false) : (!BitUtil.isSet((int)options, (int)262144) ? type.getCanonicalText(false) : type.getInternalCanonicalText());
    }

    public static String formatReference(PsiJavaCodeReferenceElement ref, int options) {
        return BitUtil.isSet((int)options, (int)8192) ? ref.getCanonicalText() : ref.getText();
    }

    @Nullable
    public static String getExternalName(PsiModifierListOwner owner) {
        return PsiFormatUtil.getExternalName(owner, true);
    }

    @Nullable
    public static String getExternalName(PsiModifierListOwner owner, boolean showParamName) {
        return PsiFormatUtil.getExternalName(owner, showParamName, 7);
    }

    @Nullable
    public static String getExternalName(PsiModifierListOwner owner, boolean showParamName, int maxParamsToShow) {
        StringBuilder builder = new StringBuilder();
        if (owner instanceof PsiClass) {
            ClassUtil.formatClassName((PsiClass)owner, builder);
            return builder.toString();
        }
        PsiClass psiClass = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)owner, PsiClass.class, (boolean)false);
        if (psiClass == null) {
            return null;
        }
        ClassUtil.formatClassName(psiClass, builder);
        if (owner instanceof PsiMethod) {
            builder.append(' ');
            int options = 10499;
            int parameterOptions = showParamName ? 8195 : 8194;
            PsiFormatUtil.formatMethod((PsiMethod)owner, PsiSubstitutor.EMPTY, options, parameterOptions, maxParamsToShow, builder);
        } else if (owner instanceof PsiField) {
            builder.append(' ').append(((PsiField)owner).getName());
        } else if (owner instanceof PsiParameter) {
            PsiElement declarationScope = ((PsiParameter)owner).getDeclarationScope();
            if (!(declarationScope instanceof PsiMethod)) {
                return null;
            }
            PsiMethod psiMethod = (PsiMethod)declarationScope;
            builder.append(' ');
            int options = 10499;
            int parameterOptions = showParamName ? 8195 : 8194;
            PsiFormatUtil.formatMethod(psiMethod, PsiSubstitutor.EMPTY, options, parameterOptions, maxParamsToShow, builder);
            builder.append(' ');
            if (showParamName) {
                PsiFormatUtil.formatVariable((PsiVariable)owner, 1, PsiSubstitutor.EMPTY, builder);
            } else {
                builder.append(psiMethod.getParameterList().getParameterIndex((PsiParameter)owner));
            }
        } else {
            return null;
        }
        return builder.toString();
    }

    public static String getPackageDisplayName(@NotNull PsiClass psiClass) {
        if (psiClass instanceof PsiTypeParameter) {
            PsiTypeParameterListOwner owner = ((PsiTypeParameter)psiClass).getOwner();
            String ownerName = null;
            if (owner instanceof PsiClass) {
                ownerName = ((PsiClass)owner).getQualifiedName();
                if (ownerName == null) {
                    ownerName = owner.getName();
                }
            } else if (owner instanceof PsiMethod) {
                ownerName = owner.getName();
            }
            return ownerName == null ? "type parameter" : "type parameter of " + ownerName;
        }
        if (PsiUtil.isLocalClass(psiClass)) {
            return "local class";
        }
        String packageName = psiClass.getQualifiedName();
        String string = packageName = packageName == null || packageName.lastIndexOf(46) <= 0 ? "" : packageName.substring(0, packageName.lastIndexOf(46));
        if (packageName.isEmpty()) {
            packageName = "default package";
        }
        return packageName;
    }

    public static @interface FormatClassOptions {
    }

    public static @interface FormatMethodOptions {
    }

    public static @interface FormatVariableOptions {
    }
}

