/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.util;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.FileIndexFacade;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.HierarchicalMethodSignature;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.MethodSignature;
import com.intellij.psi.util.MethodSignatureBackedByPsiMethod;
import com.intellij.psi.util.MethodSignatureUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.TypeConversionUtil;
import gnu.trove.THashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PsiSuperMethodUtil {
    private PsiSuperMethodUtil() {
    }

    public static boolean isSuperMethod(@NotNull PsiMethod method, @NotNull PsiMethod superMethod) {
        HierarchicalMethodSignature signature = method.getHierarchicalMethodSignature();
        for (HierarchicalMethodSignature supsig : signature.getSuperSignatures()) {
            PsiMethod supsigme = supsig.getMethod();
            if (!superMethod.equals(supsigme) && !PsiSuperMethodUtil.isSuperMethod(supsigme, superMethod)) continue;
            return true;
        }
        return false;
    }

    @NotNull
    public static PsiSubstitutor obtainFinalSubstitutor(@NotNull PsiClass superClass, @NotNull PsiSubstitutor superSubstitutor, @NotNull PsiSubstitutor derivedSubstitutor, boolean inRawContext) {
        if (inRawContext) {
            Set<PsiTypeParameter> typeParams = superSubstitutor.getSubstitutionMap().keySet();
            PsiElementFactory factory = JavaPsiFacade.getElementFactory(superClass.getProject());
            superSubstitutor = factory.createRawSubstitutor(derivedSubstitutor, typeParams.toArray(PsiTypeParameter.EMPTY_ARRAY));
        }
        THashMap map = null;
        for (PsiTypeParameter typeParameter : PsiUtil.typeParametersIterable(superClass)) {
            PsiType type = superSubstitutor.substitute(typeParameter);
            PsiType t = derivedSubstitutor.substitute(type);
            if (map == null) {
                map = new THashMap();
            }
            map.put(typeParameter, t);
        }
        return map == null ? PsiSubstitutor.EMPTY : JavaPsiFacade.getElementFactory(superClass.getProject()).createSubstitutor((Map<PsiTypeParameter, PsiType>)map);
    }

    @NotNull
    public static Map<MethodSignature, Set<PsiMethod>> collectOverrideEquivalents(@NotNull PsiClass aClass) {
        THashMap overrideEquivalent = new THashMap(MethodSignatureUtil.METHOD_PARAMETERS_ERASURE_EQUALITY);
        GlobalSearchScope resolveScope = aClass.getResolveScope();
        PsiClass[] supers = aClass.getSupers();
        for (int i = 0; i < supers.length; ++i) {
            PsiClass superClass = supers[i];
            boolean subType = false;
            for (int j = 0; j < supers.length; ++j) {
                if (j == i) continue;
                subType |= supers[j].isInheritor(supers[i], true);
            }
            if (subType) continue;
            PsiSubstitutor superClassSubstitutor = TypeConversionUtil.getSuperClassSubstitutor(superClass, aClass, PsiSubstitutor.EMPTY);
            for (HierarchicalMethodSignature hms : superClass.getVisibleSignatures()) {
                PsiSubstitutor containingClassSubstitutor;
                PsiClass containingClass;
                PsiMethod method = hms.getMethod();
                if (MethodSignatureUtil.findMethodBySignature(aClass, method.getSignature(superClassSubstitutor), false) != null || (containingClass = PsiSuperMethodUtil.correctClassByScope(method.getContainingClass(), resolveScope)) == null || (method = containingClass.findMethodBySignature(method, false)) == null || (containingClassSubstitutor = TypeConversionUtil.getClassSubstitutor(containingClass, aClass, PsiSubstitutor.EMPTY)) == null) continue;
                PsiSubstitutor finalSubstitutor = PsiSuperMethodUtil.obtainFinalSubstitutor(containingClass, containingClassSubstitutor, hms.getSubstitutor(), false);
                MethodSignatureBackedByPsiMethod signature = MethodSignatureBackedByPsiMethod.create(method, finalSubstitutor, false);
                LinkedHashSet<PsiMethod> methods = (LinkedHashSet<PsiMethod>)overrideEquivalent.get(signature);
                if (methods == null) {
                    methods = new LinkedHashSet<PsiMethod>();
                    overrideEquivalent.put(signature, methods);
                }
                methods.add(method);
            }
        }
        return overrideEquivalent;
    }

    @Nullable
    public static PsiClass correctClassByScope(PsiClass psiClass, GlobalSearchScope resolveScope) {
        if (psiClass == null) {
            return null;
        }
        String qualifiedName = psiClass.getQualifiedName();
        if (qualifiedName == null) {
            return psiClass;
        }
        PsiFile file = psiClass.getContainingFile();
        if (file == null || !file.getViewProvider().isPhysical()) {
            return psiClass;
        }
        VirtualFile vFile = file.getVirtualFile();
        if (vFile == null) {
            return psiClass;
        }
        FileIndexFacade index = FileIndexFacade.getInstance((Project)file.getProject());
        if (!(index.isInSource(vFile) || index.isInLibrarySource(vFile) || index.isInLibraryClasses(vFile))) {
            return psiClass;
        }
        return JavaPsiFacade.getInstance(psiClass.getProject()).findClass(qualifiedName, resolveScope);
    }
}

