/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.util;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Condition;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.LambdaUtil;
import com.intellij.psi.PsiArrayInitializerExpression;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiCapturedWildcardType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiDisjunctionType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiEllipsisType;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiIntersectionType;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodReferenceExpression;
import com.intellij.psi.PsiMethodReferenceUtil;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiTypeParameterListOwner;
import com.intellij.psi.PsiTypeVisitor;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.PsiWildcardType;
import com.intellij.psi.StubBasedPsiElement;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.util.IncorrectOperationException;
import gnu.trove.THashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PsiTypesUtil {
    @NonNls
    private static final Map<String, String> ourUnboxedTypes = new THashMap();
    @NonNls
    private static final Map<String, String> ourBoxedTypes = new THashMap();
    @NonNls
    private static final String GET_CLASS_METHOD = "getClass";

    private PsiTypesUtil() {
    }

    public static Object getDefaultValue(PsiType type) {
        if (!(type instanceof PsiPrimitiveType)) {
            return null;
        }
        switch (type.getCanonicalText()) {
            case "boolean": {
                return false;
            }
            case "byte": {
                return (byte)0;
            }
            case "char": {
                return Character.valueOf('\u0000');
            }
            case "short": {
                return (short)0;
            }
            case "int": {
                return 0;
            }
            case "long": {
                return 0L;
            }
            case "float": {
                return Float.valueOf(0.0f);
            }
            case "double": {
                return 0.0;
            }
        }
        return null;
    }

    @NotNull
    public static String getDefaultValueOfType(PsiType type) {
        return PsiTypesUtil.getDefaultValueOfType(type, false);
    }

    @NotNull
    public static String getDefaultValueOfType(PsiType type, boolean customDefaultValues) {
        if (type instanceof PsiArrayType) {
            PsiClassType classType;
            int count = type.getArrayDimensions() - 1;
            PsiType componentType = type.getDeepComponentType();
            if (componentType instanceof PsiClassType && (classType = (PsiClassType)componentType).resolve() instanceof PsiTypeParameter) {
                return "null";
            }
            PsiType erasedComponentType = TypeConversionUtil.erasure(componentType);
            StringBuilder buffer = new StringBuilder();
            buffer.append("new");
            buffer.append(" ");
            buffer.append(erasedComponentType.getCanonicalText());
            buffer.append("[0]");
            for (int i = 0; i < count; ++i) {
                buffer.append("[]");
            }
            return buffer.toString();
        }
        if (type instanceof PsiPrimitiveType) {
            return PsiType.BOOLEAN.equals(type) ? "false" : "0";
        }
        if (customDefaultValues) {
            PsiClassType rawType;
            PsiClassType psiClassType = rawType = type instanceof PsiClassType ? ((PsiClassType)type).rawType() : null;
            if (rawType != null && rawType.equalsToText("java.util.Optional")) {
                return "java.util.Optional.empty()";
            }
        }
        return "null";
    }

    @Contract(value="null -> null; !null -> !null")
    @Nullable
    public static String unboxIfPossible(@Nullable String type) {
        if (type == null) {
            return null;
        }
        String s = ourUnboxedTypes.get(type);
        return s == null ? type : s;
    }

    @Contract(value="null -> null; !null -> !null")
    @Nullable
    public static String boxIfPossible(@Nullable String type) {
        if (type == null) {
            return null;
        }
        String s = ourBoxedTypes.get(type);
        return s == null ? type : s;
    }

    @Nullable
    public static PsiClass getPsiClass(@Nullable PsiType psiType) {
        return psiType instanceof PsiClassType ? ((PsiClassType)psiType).resolve() : null;
    }

    @NotNull
    public static PsiClassType getClassType(@NotNull PsiClass psiClass) {
        return JavaPsiFacade.getElementFactory(psiClass.getProject()).createType(psiClass);
    }

    @Nullable
    public static PsiClassType getLowestUpperBoundClassType(@NotNull PsiDisjunctionType type) {
        PsiType lub = type.getLeastUpperBound();
        if (lub instanceof PsiClassType) {
            return (PsiClassType)lub;
        }
        if (lub instanceof PsiIntersectionType) {
            for (PsiType subType : ((PsiIntersectionType)lub).getConjuncts()) {
                PsiClass aClass;
                if (!(subType instanceof PsiClassType) || (aClass = ((PsiClassType)subType).resolve()) == null || aClass.isInterface()) continue;
                return (PsiClassType)subType;
            }
        }
        return null;
    }

    public static PsiType patchMethodGetClassReturnType(@NotNull PsiMethodReferenceExpression methodExpression, @NotNull PsiMethod method) {
        if (PsiTypesUtil.isGetClass(method)) {
            PsiType qualifierType = PsiMethodReferenceUtil.getQualifierType(methodExpression);
            return qualifierType != null ? PsiTypesUtil.createJavaLangClassType(methodExpression, qualifierType, true) : null;
        }
        return null;
    }

    public static PsiType patchMethodGetClassReturnType(@NotNull PsiExpression call, @NotNull PsiReferenceExpression methodExpression, @NotNull PsiMethod method, @NotNull Condition<? super IElementType> condition2, @NotNull LanguageLevel languageLevel) {
        if (languageLevel.isAtLeast(LanguageLevel.JDK_1_5) && PsiTypesUtil.isGetClass(method)) {
            PsiExpression qualifier = methodExpression.getQualifierExpression();
            PsiType qualifierType = null;
            Project project = call.getProject();
            if (qualifier != null) {
                qualifierType = TypeConversionUtil.erasure(qualifier.getType());
            } else {
                PsiElement parent;
                for (parent = call.getContext(); parent != null && condition2.value(parent instanceof StubBasedPsiElement ? ((StubBasedPsiElement)parent).getElementType() : parent.getNode().getElementType()); parent = parent.getContext()) {
                }
                if (parent != null) {
                    qualifierType = JavaPsiFacade.getElementFactory(project).createType((PsiClass)parent);
                }
            }
            return PsiTypesUtil.createJavaLangClassType(methodExpression, qualifierType, true);
        }
        return null;
    }

    public static boolean isGetClass(@NotNull PsiMethod method) {
        if (GET_CLASS_METHOD.equals(method.getName())) {
            PsiClass aClass = method.getContainingClass();
            return aClass != null && "java.lang.Object".equals(aClass.getQualifiedName());
        }
        return false;
    }

    @Nullable
    public static PsiType createJavaLangClassType(@NotNull PsiElement context, @Nullable PsiType qualifierType, boolean captureTopLevelWildcards) {
        if (qualifierType != null) {
            PsiUtil.ensureValidType(qualifierType);
            JavaPsiFacade facade = JavaPsiFacade.getInstance(context.getProject());
            PsiClass javaLangClass = facade.findClass("java.lang.Class", context.getResolveScope());
            if (javaLangClass != null && javaLangClass.getTypeParameters().length == 1) {
                PsiSubstitutor substitutor = PsiSubstitutor.EMPTY.put(javaLangClass.getTypeParameters()[0], PsiWildcardType.createExtends(context.getManager(), qualifierType));
                PsiClassType classType = facade.getElementFactory().createType(javaLangClass, substitutor, PsiUtil.getLanguageLevel(context));
                return captureTopLevelWildcards ? PsiUtil.captureToplevelWildcards(classType, context) : classType;
            }
        }
        return null;
    }

    @Nullable
    public static PsiType getExpectedTypeByParent(@NotNull PsiElement element) {
        PsiElement parent = PsiUtil.skipParenthesizedExprUp(element.getParent());
        if (parent instanceof PsiVariable) {
            if (PsiUtil.checkSameExpression(element, ((PsiVariable)parent).getInitializer())) {
                PsiTypeElement typeElement = ((PsiVariable)parent).getTypeElement();
                if (typeElement != null && typeElement.isInferredType()) {
                    return null;
                }
                return ((PsiVariable)parent).getType();
            }
        } else if (parent instanceof PsiAssignmentExpression) {
            if (PsiUtil.checkSameExpression(element, ((PsiAssignmentExpression)parent).getRExpression())) {
                PsiType type = ((PsiAssignmentExpression)parent).getLExpression().getType();
                return !PsiType.NULL.equals(type) ? type : null;
            }
        } else if (parent instanceof PsiReturnStatement) {
            PsiElement psiElement = PsiTreeUtil.getParentOfType((PsiElement)parent, (Class[])new Class[]{PsiLambdaExpression.class, PsiMethod.class});
            if (psiElement instanceof PsiLambdaExpression) {
                return null;
            }
            if (psiElement instanceof PsiMethod) {
                return ((PsiMethod)psiElement).getReturnType();
            }
        } else {
            if (PsiUtil.isCondition(element, parent)) {
                return PsiType.BOOLEAN;
            }
            if (parent instanceof PsiArrayInitializerExpression) {
                PsiElement gParent = parent.getParent();
                if (gParent instanceof PsiNewExpression) {
                    PsiType type = ((PsiNewExpression)gParent).getType();
                    if (type instanceof PsiArrayType) {
                        return ((PsiArrayType)type).getComponentType();
                    }
                } else if (gParent instanceof PsiVariable) {
                    PsiType type = ((PsiVariable)gParent).getType();
                    if (type instanceof PsiArrayType) {
                        return ((PsiArrayType)type).getComponentType();
                    }
                } else if (gParent instanceof PsiArrayInitializerExpression) {
                    PsiType expectedTypeByParent = PsiTypesUtil.getExpectedTypeByParent(parent);
                    return expectedTypeByParent instanceof PsiArrayType ? ((PsiArrayType)expectedTypeByParent).getComponentType() : null;
                }
            }
        }
        return null;
    }

    @Nullable
    public static PsiType getMethodReturnType(@NotNull PsiElement element) {
        PsiElement methodOrLambda = PsiTreeUtil.getParentOfType((PsiElement)element, (Class[])new Class[]{PsiMethod.class, PsiLambdaExpression.class});
        return methodOrLambda instanceof PsiMethod ? ((PsiMethod)methodOrLambda).getReturnType() : (methodOrLambda instanceof PsiLambdaExpression ? LambdaUtil.getFunctionalInterfaceReturnType((PsiLambdaExpression)methodOrLambda) : null);
    }

    public static boolean compareTypes(PsiType leftType, PsiType rightType, boolean ignoreEllipsis) {
        if (ignoreEllipsis) {
            if (leftType instanceof PsiEllipsisType) {
                leftType = ((PsiEllipsisType)leftType).toArrayType();
            }
            if (rightType instanceof PsiEllipsisType) {
                rightType = ((PsiEllipsisType)rightType).toArrayType();
            }
        }
        return Comparing.equal((Object)leftType, (Object)rightType);
    }

    @Deprecated
    public static boolean isDenotableType(@Nullable PsiType type) {
        return !(type instanceof PsiWildcardType) && !(type instanceof PsiCapturedWildcardType);
    }

    public static boolean isDenotableType(@Nullable PsiType type, @NotNull PsiElement context) {
        if (type == null || type instanceof PsiWildcardType) {
            return false;
        }
        PsiElementFactory elementFactory = JavaPsiFacade.getElementFactory(context.getProject());
        try {
            PsiType typeAfterReplacement = elementFactory.createTypeElementFromText(type.getCanonicalText(), context).getType();
            return type.equals(typeAfterReplacement);
        }
        catch (IncorrectOperationException e) {
            return false;
        }
    }

    public static boolean hasUnresolvedComponents(@NotNull PsiType type) {
        return type.accept(new PsiTypeVisitor<Boolean>(){

            @Override
            @Nullable
            public Boolean visitClassType(PsiClassType classType) {
                PsiClassType.ClassResolveResult resolveResult = classType.resolveGenerics();
                PsiClass psiClass = resolveResult.getElement();
                if (psiClass == null) {
                    return true;
                }
                PsiSubstitutor substitutor = resolveResult.getSubstitutor();
                for (PsiTypeParameter param : PsiUtil.typeParametersIterable(psiClass)) {
                    PsiType psiType = substitutor.substitute(param);
                    if (psiType == null || !psiType.accept(this).booleanValue()) continue;
                    return true;
                }
                return (Boolean)super.visitClassType(classType);
            }

            @Override
            @Nullable
            public Boolean visitArrayType(PsiArrayType arrayType) {
                return arrayType.getComponentType().accept(this);
            }

            @Override
            @NotNull
            public Boolean visitWildcardType(PsiWildcardType wildcardType) {
                PsiType bound = wildcardType.getBound();
                return bound != null && bound.accept(this) != false;
            }

            @Override
            public Boolean visitType(PsiType type) {
                return false;
            }
        });
    }

    @NotNull
    public static PsiType getParameterType(@NotNull PsiParameter[] parameters, int i, boolean varargs) {
        PsiParameter parameter = parameters[i < parameters.length ? i : parameters.length - 1];
        PsiType parameterType = parameter.getType();
        if (parameterType instanceof PsiEllipsisType && varargs) {
            parameterType = ((PsiEllipsisType)parameterType).getComponentType();
        }
        if (!parameterType.isValid()) {
            PsiUtil.ensureValidType(parameterType, "Invalid type of parameter " + parameter + " of " + parameter.getClass());
        }
        return parameterType;
    }

    @NotNull
    public static PsiTypeParameter[] filterUnusedTypeParameters(@NotNull PsiTypeParameter[] typeParameters, PsiType ... types) {
        if (typeParameters.length == 0) {
            return PsiTypeParameter.EMPTY_ARRAY;
        }
        TypeParameterSearcher searcher = new TypeParameterSearcher();
        for (PsiType type : types) {
            type.accept(searcher);
        }
        return searcher.getTypeParameters().toArray(PsiTypeParameter.EMPTY_ARRAY);
    }

    @NotNull
    public static PsiTypeParameter[] filterUnusedTypeParameters(@NotNull PsiType superReturnTypeInBaseClassType, @NotNull PsiTypeParameter[] typeParameters) {
        return PsiTypesUtil.filterUnusedTypeParameters(typeParameters, superReturnTypeInBaseClassType);
    }

    private static boolean isAccessibleAt(@NotNull PsiTypeParameter parameter, @NotNull PsiElement context) {
        PsiTypeParameterListOwner owner = parameter.getOwner();
        if (owner instanceof PsiMethod) {
            return PsiTreeUtil.isAncestor((PsiElement)owner, (PsiElement)context, (boolean)false);
        }
        if (owner instanceof PsiClass) {
            return PsiTreeUtil.isAncestor((PsiElement)owner, (PsiElement)context, (boolean)false) && InheritanceUtil.hasEnclosingInstanceInScope((PsiClass)owner, context, false, false);
        }
        return false;
    }

    public static boolean allTypeParametersResolved(@NotNull PsiElement context, @NotNull PsiType targetType) {
        TypeParameterSearcher searcher = new TypeParameterSearcher();
        targetType.accept(searcher);
        Set<PsiTypeParameter> parameters = searcher.getTypeParameters();
        return parameters.stream().allMatch(parameter -> PsiTypesUtil.isAccessibleAt(parameter, context));
    }

    @NotNull
    public static PsiType createArrayType(@NotNull PsiType newType, int arrayDim) {
        for (int i = 0; i < arrayDim; ++i) {
            newType = newType.createArrayType();
        }
        return newType;
    }

    @Nullable
    public static PsiTypeElement replaceWithExplicitType(PsiTypeElement typeElement) {
        PsiType type = typeElement.getType();
        if (!PsiTypesUtil.isDenotableType(type, typeElement)) {
            return null;
        }
        Project project = typeElement.getProject();
        PsiTypeElement typeElementByExplicitType = JavaPsiFacade.getElementFactory(project).createTypeElement(type);
        PsiElement explicitTypeElement = typeElement.replace(typeElementByExplicitType);
        explicitTypeElement = JavaCodeStyleManager.getInstance(project).shortenClassReferences(explicitTypeElement);
        return (PsiTypeElement)CodeStyleManager.getInstance((Project)project).reformat(explicitTypeElement);
    }

    static {
        ourUnboxedTypes.put("java.lang.Boolean", "boolean");
        ourUnboxedTypes.put("java.lang.Byte", "byte");
        ourUnboxedTypes.put("java.lang.Short", "short");
        ourUnboxedTypes.put("java.lang.Integer", "int");
        ourUnboxedTypes.put("java.lang.Long", "long");
        ourUnboxedTypes.put("java.lang.Float", "float");
        ourUnboxedTypes.put("java.lang.Double", "double");
        ourUnboxedTypes.put("java.lang.Character", "char");
        ourBoxedTypes.put("boolean", "java.lang.Boolean");
        ourBoxedTypes.put("byte", "java.lang.Byte");
        ourBoxedTypes.put("short", "java.lang.Short");
        ourBoxedTypes.put("int", "java.lang.Integer");
        ourBoxedTypes.put("long", "java.lang.Long");
        ourBoxedTypes.put("float", "java.lang.Float");
        ourBoxedTypes.put("double", "java.lang.Double");
        ourBoxedTypes.put("char", "java.lang.Character");
    }

    public static class TypeParameterSearcher
    extends PsiTypeVisitor<Boolean> {
        private final Set<PsiTypeParameter> myTypeParams = new HashSet<PsiTypeParameter>();

        @NotNull
        public Set<PsiTypeParameter> getTypeParameters() {
            return this.myTypeParams;
        }

        @Override
        public Boolean visitType(PsiType type) {
            return false;
        }

        @Override
        public Boolean visitArrayType(PsiArrayType arrayType) {
            return arrayType.getComponentType().accept(this);
        }

        @Override
        public Boolean visitClassType(PsiClassType classType) {
            PsiClassType.ClassResolveResult resolveResult = classType.resolveGenerics();
            PsiClass aClass = resolveResult.getElement();
            if (aClass instanceof PsiTypeParameter) {
                this.myTypeParams.add((PsiTypeParameter)aClass);
            }
            if (aClass != null) {
                PsiSubstitutor substitutor = resolveResult.getSubstitutor();
                for (PsiTypeParameter parameter : PsiUtil.typeParametersIterable(aClass)) {
                    PsiType psiType = substitutor.substitute(parameter);
                    if (psiType == null) continue;
                    psiType.accept(this);
                }
            }
            return false;
        }

        @Override
        public Boolean visitWildcardType(PsiWildcardType wildcardType) {
            PsiType bound = wildcardType.getBound();
            if (bound != null) {
                bound.accept(this);
            }
            return false;
        }
    }
}

