/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.uast;

import com.intellij.lang.Language;
import com.intellij.lang.MetaLanguage;
import gnu.trove.THashSet;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.uast.UastLanguagePlugin;

public class UastMetaLanguage
extends MetaLanguage {
    private final Set<Language> myLanguages;

    protected UastMetaLanguage() {
        super("UAST");
        Collection<UastLanguagePlugin> languagePlugins = UastLanguagePlugin.Companion.getInstances();
        this.myLanguages = new THashSet(languagePlugins.size());
        for (UastLanguagePlugin plugin : languagePlugins) {
            this.myLanguages.add(plugin.getLanguage());
        }
    }

    public boolean matchesLanguage(@NotNull Language language) {
        return this.myLanguages.contains(language);
    }

    @NotNull
    public Collection<Language> getMatchingLanguages() {
        return Collections.unmodifiableSet(this.myLanguages);
    }
}

