/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.modules;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ModuleRootModel;
import com.intellij.openapi.util.Couple;
import com.intellij.util.Chunk;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.graph.CachingSemiGraph;
import com.intellij.util.graph.Graph;
import com.intellij.util.graph.GraphAlgorithms;
import com.intellij.util.graph.GraphGenerator;
import com.intellij.util.graph.InboundSemiGraph;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CircularModuleDependenciesDetector {
    @NotNull
    private static <T extends ModuleRootModel> Graph<T> createGraphGenerator(final @NotNull Map<Module, T> models) {
        return GraphGenerator.generate((InboundSemiGraph)CachingSemiGraph.cache((InboundSemiGraph)new InboundSemiGraph<T>(){

            @NotNull
            public Collection<T> getNodes() {
                return models.values();
            }

            @NotNull
            public Iterator<T> getIn(ModuleRootModel model) {
                ArrayList dependencies = new ArrayList();
                model.orderEntries().compileOnly().forEachModule(module -> {
                    ModuleRootModel depModel = (ModuleRootModel)models.get(module);
                    if (depModel != null) {
                        dependencies.add(depModel);
                    }
                    return true;
                });
                return dependencies.iterator();
            }
        }));
    }

    @NotNull
    private static <T extends ModuleRootModel> Collection<Chunk<T>> buildChunks(@NotNull Map<Module, T> models) {
        return GraphAlgorithms.getInstance().computeSCCGraph(CircularModuleDependenciesDetector.createGraphGenerator(models)).getNodes();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public static Couple<Module> addingDependencyFormsCircularity(@NotNull Module currentModule, @NotNull Module toDependOn) {
        assert (currentModule != toDependOn);
        LinkedHashMap<Module, ModifiableRootModel> models = new LinkedHashMap<Module, ModifiableRootModel>();
        Project project = currentModule.getProject();
        for (Module module : ModuleManager.getInstance((Project)project).getModules()) {
            ModifiableRootModel modifiableRootModel = ModuleRootManager.getInstance((Module)module).getModifiableModel();
            models.put(module, modifiableRootModel);
        }
        ModifiableRootModel currentModel = (ModifiableRootModel)models.get(currentModule);
        ModifiableRootModel toDependOnModel = (ModifiableRootModel)models.get(toDependOn);
        Collection nodesBefore = CircularModuleDependenciesDetector.buildChunks(models);
        for (Chunk chunk : nodesBefore) {
            if (!chunk.containsNode((Object)toDependOnModel) || !chunk.containsNode((Object)currentModel)) continue;
            return null;
        }
        try {
            currentModel.addModuleOrderEntry(toDependOn);
            Collection nodesAfter = CircularModuleDependenciesDetector.buildChunks(models);
            for (Chunk chunk : nodesAfter) {
                if (!chunk.containsNode((Object)toDependOnModel) || !chunk.containsNode((Object)currentModel)) continue;
                List nodes = ContainerUtil.collect(chunk.getNodes().iterator());
                nodes.sort(Comparator.comparing(m -> m.getModule().getName()));
                Couple couple = Couple.of((Object)((ModifiableRootModel)nodes.get(0)).getModule(), (Object)((ModifiableRootModel)nodes.get(1)).getModule());
                return couple;
            }
        }
        finally {
            for (ModifiableRootModel model : models.values()) {
                model.dispose();
            }
        }
        return null;
    }
}

