/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.utils.library;

import com.intellij.jarRepository.RepositoryLibraryDefinition;
import com.intellij.openapi.roots.DependencyScope;
import com.intellij.util.containers.ContainerUtil;
import icons.OpenapiIcons;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.maven.utils.library.RepositoryLibraryProperties;
import org.jetbrains.jps.model.library.JpsMavenRepositoryLibraryDescriptor;

public class RepositoryLibraryDescription {
    @NotNull
    public static final String LatestVersionId = "LATEST";
    @NotNull
    public static final String LatestVersionDisplayName = "Latest";
    @NotNull
    public static final String ReleaseVersionId = "RELEASE";
    @NotNull
    public static final String DefaultVersionId = "RELEASE";
    @NotNull
    public static final String ReleaseVersionDisplayName = "Release";
    @NotNull
    public static final String SnapshotVersionSuffix = "-SNAPSHOT";
    public static final Icon DEFAULT_ICON = OpenapiIcons.RepositoryLibraryLogo;
    private static volatile Map<String, RepositoryLibraryDescription> ourStaticallyDefinedLibraries;
    private final String groupId;
    private final String artifactId;
    private final String libraryName;

    protected RepositoryLibraryDescription(String groupId, String artifactId, String libraryName) {
        this.groupId = groupId == null ? "" : groupId;
        this.artifactId = artifactId == null ? "" : artifactId;
        this.libraryName = libraryName == null ? "<unknown>" : libraryName;
    }

    @NotNull
    public static RepositoryLibraryDescription findDescription(@Nullable String groupId, @Nullable String artifactId) {
        if (ourStaticallyDefinedLibraries == null) {
            HashMap<String, RepositoryLibraryDescription> map = new HashMap<String, RepositoryLibraryDescription>();
            for (RepositoryLibraryDefinition def : (RepositoryLibraryDefinition[])RepositoryLibraryDefinition.EP_NAME.getExtensions()) {
                String id = def.groupId + ":" + def.artifactId;
                map.put(id, new RepositoryLibraryDescription(def.groupId, def.artifactId, def.name));
            }
            ourStaticallyDefinedLibraries = Collections.unmodifiableMap(Collections.synchronizedMap(map));
        }
        String id = groupId == null && artifactId == null ? "<unknown>" : groupId + ":" + artifactId;
        RepositoryLibraryDescription description = ourStaticallyDefinedLibraries.get(id);
        return description != null ? description : new RepositoryLibraryDescription(groupId, artifactId, id);
    }

    @NotNull
    public static RepositoryLibraryDescription findDescription(@NotNull RepositoryLibraryProperties properties) {
        return RepositoryLibraryDescription.findDescription(properties.getGroupId(), properties.getArtifactId());
    }

    @NotNull
    public static RepositoryLibraryDescription findDescription(@NotNull JpsMavenRepositoryLibraryDescriptor descriptor) {
        return RepositoryLibraryDescription.findDescription(descriptor.getGroupId(), descriptor.getArtifactId());
    }

    @NotNull
    public String getGroupId() {
        return this.groupId;
    }

    @NotNull
    public String getArtifactId() {
        return this.artifactId;
    }

    @NotNull
    public String getDisplayName() {
        return this.libraryName;
    }

    @NotNull
    public Icon getIcon() {
        return DEFAULT_ICON;
    }

    @Nullable
    public DependencyScope getSuggestedScope() {
        return null;
    }

    public int getWeight() {
        return 1000;
    }

    public RepositoryLibraryProperties createDefaultProperties() {
        return new RepositoryLibraryProperties(this.getGroupId(), this.getArtifactId(), "RELEASE", true, ContainerUtil.emptyList());
    }

    public String getDisplayName(String version) {
        if (LatestVersionId.equals(version)) {
            version = LatestVersionDisplayName;
        } else if ("RELEASE".equals(version)) {
            version = ReleaseVersionDisplayName;
        }
        return this.getDisplayName() + (version == null ? "" : ":" + version);
    }

    public String getMavenCoordinates(String version) {
        return this.getGroupId() + ":" + this.getArtifactId() + ":" + version;
    }
}

