/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.application.options;

import com.intellij.application.options.CodeStyleCachingUtil;
import com.intellij.lang.Language;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.CodeStyleSettingsManager;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import com.intellij.psi.codeStyle.CustomCodeStyleSettings;
import com.intellij.psi.codeStyle.FileCodeStyleProvider;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CodeStyle {
    private CodeStyle() {
    }

    @NotNull
    public static CodeStyleSettings getDefaultSettings() {
        return CodeStyleSettingsManager.getInstance().getCurrentSettings();
    }

    @NotNull
    public static CodeStyleSettings getSettings(@NotNull Project project) {
        return CodeStyleSettingsManager.getInstance(project).getCurrentSettings();
    }

    @NotNull
    public static CodeStyleSettings getProjectOrDefaultSettings(@Nullable Project project) {
        return project != null ? CodeStyle.getSettings(project) : CodeStyle.getDefaultSettings();
    }

    @NotNull
    public static CodeStyleSettings getSettings(@NotNull PsiFile file) {
        for (FileCodeStyleProvider provider : FileCodeStyleProvider.EP_NAME.getExtensionList()) {
            CodeStyleSettings fileSettings = provider.getSettings(file);
            if (fileSettings == null) continue;
            return fileSettings;
        }
        return CodeStyleCachingUtil.getCachedCodeStyle(file);
    }

    public static CodeStyleSettings getSettings(@NotNull Editor editor) {
        Project project = editor.getProject();
        if (project != null) {
            PsiFile file = PsiDocumentManager.getInstance(project).getPsiFile(editor.getDocument());
            if (file != null) {
                return CodeStyle.getSettings(file);
            }
            return CodeStyle.getSettings(project);
        }
        return CodeStyle.getDefaultSettings();
    }

    @Nullable
    public static CommonCodeStyleSettings getLanguageSettings(@NotNull Editor editor) {
        PsiFile file;
        Project project = editor.getProject();
        if (project != null && (file = PsiDocumentManager.getInstance(project).getPsiFile(editor.getDocument())) != null) {
            return CodeStyle.getLanguageSettings(file);
        }
        return null;
    }

    @NotNull
    public static <T extends CustomCodeStyleSettings> T getCustomSettings(@NotNull PsiFile file, Class<T> customSettingsClass) {
        CodeStyleSettings rootSettings = CodeStyle.getSettings(file);
        return rootSettings.getCustomSettings(customSettingsClass);
    }

    @NotNull
    public static CommonCodeStyleSettings getLanguageSettings(@NotNull PsiFile file) {
        CodeStyleSettings rootSettings = CodeStyle.getSettings(file);
        return rootSettings.getCommonSettings(file.getLanguage());
    }

    @NotNull
    public static CommonCodeStyleSettings getLanguageSettings(@NotNull PsiFile file, @NotNull Language language) {
        CodeStyleSettings rootSettings = CodeStyle.getSettings(file);
        return rootSettings.getCommonSettings(language);
    }

    @NotNull
    public static CommonCodeStyleSettings.IndentOptions getIndentOptions(@NotNull PsiFile file) {
        CodeStyleSettings rootSettings = CodeStyle.getSettings(file);
        return rootSettings.getIndentOptionsByFile(file);
    }

    @NotNull
    public static CommonCodeStyleSettings.IndentOptions getIndentOptionsByFileType(@NotNull Project project, @Nullable VirtualFile file) {
        return file != null ? CodeStyle.getSettings(project).getIndentOptions(file.getFileType()) : CodeStyle.getSettings(project).getIndentOptions();
    }

    @NotNull
    public static CommonCodeStyleSettings.IndentOptions getIndentOptions(@NotNull Project project, @NotNull Document document) {
        PsiFile file = PsiDocumentManager.getInstance(project).getPsiFile(document);
        if (file != null) {
            return CodeStyle.getIndentOptions(file);
        }
        return CodeStyle.getSettings(project).getIndentOptions((FileType)null);
    }

    public static int getIndentSize(@NotNull PsiFile file) {
        return CodeStyle.getIndentOptions((PsiFile)file).INDENT_SIZE;
    }

    public static void setTemporarySettings(@Nullable Project project, @NotNull CodeStyleSettings settings) {
        CodeStyleSettingsManager.getInstance(project).setTemporarySettings(settings);
    }

    public static void dropTemporarySettings(@Nullable Project project) {
        CodeStyleSettingsManager.getInstance(project).dropTemporarySettings();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void doWithTemporarySettings(@NotNull Project project, @NotNull CodeStyleSettings tempSettings, @NotNull Runnable runnable) {
        CodeStyleSettingsManager settingsManager = CodeStyleSettingsManager.getInstance(project);
        CodeStyleSettings tempSettingsBefore = settingsManager.getTemporarySettings();
        try {
            settingsManager.setTemporarySettings(tempSettings);
            runnable.run();
        }
        finally {
            if (tempSettingsBefore != null) {
                settingsManager.setTemporarySettings(tempSettingsBefore);
            } else {
                settingsManager.dropTemporarySettings();
            }
        }
    }

    public static boolean usesOwnSettings(@NotNull Project project) {
        return CodeStyleSettingsManager.getInstance((Project)project).USE_PER_PROJECT_SETTINGS;
    }

    public static void updateDocumentIndentOptions(@NotNull Project project, @NotNull Document document) {
        PsiFile file;
        PsiDocumentManager documentManager;
        if (!project.isDisposed() && (documentManager = PsiDocumentManager.getInstance(project)) != null && (file = documentManager.getPsiFile(document)) != null) {
            CommonCodeStyleSettings.IndentOptions indentOptions = CodeStyle.getSettings(file).getIndentOptionsByFile(file, null, true, null);
            indentOptions.associateWithDocument(document);
        }
    }

    public static void setMainProjectSettings(@NotNull Project project, @NotNull CodeStyleSettings settings) {
        CodeStyleSettingsManager codeStyleSettingsManager = CodeStyleSettingsManager.getInstance(project);
        codeStyleSettingsManager.setMainProjectCodeStyle(settings);
        codeStyleSettingsManager.USE_PER_PROJECT_SETTINGS = true;
    }

    public static boolean isFormattingEnabled(@NotNull PsiFile file) {
        return !CodeStyle.getSettings(file).getExcludedFiles().contains(file);
    }
}

