/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.application.options;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.CodeStyleSettingsManager;
import com.intellij.psi.codeStyle.modifier.CodeStyleSettingsModifier;
import com.intellij.psi.codeStyle.modifier.TransientCodeStyleSettings;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import org.jetbrains.annotations.NotNull;

class CodeStyleCachingUtil {
    private static final Logger LOG = Logger.getInstance(CodeStyleCachingUtil.class);
    private static final ExtensionPointName<CodeStyleSettingsModifier> CODE_STYLE_SETTINGS_MODIFIER_EP_NAME = ExtensionPointName.create((String)"com.intellij.codeStyleSettingsModifier");

    CodeStyleCachingUtil() {
    }

    @NotNull
    static CodeStyleSettings getCachedCodeStyle(@NotNull PsiFile file) {
        CachedCodeStyleHolder cachedCodeStyleHolder = (CachedCodeStyleHolder)CachedValuesManager.getCachedValue(file, () -> {
            CachedCodeStyleHolder holder = new CachedCodeStyleHolder(file);
            if (LOG.isDebugEnabled()) {
                CodeStyleCachingUtil.logCached(file, holder);
            }
            return new CachedValueProvider.Result<CachedCodeStyleHolder>(holder, holder.getDependencies());
        });
        return cachedCodeStyleHolder.getCachedSettings();
    }

    private static void logCached(@NotNull PsiFile file, @NotNull CachedCodeStyleHolder holder) {
        CodeStyleSettings settings = holder.getCachedSettings();
        LOG.debug(String.format("File: %s, cached: %s, tracker: %d", file.getName(), settings, settings.getModificationTracker().getModificationCount()));
    }

    static class CachedCodeStyleHolder {
        @NotNull
        private CodeStyleSettings myCachedSettings;

        CachedCodeStyleHolder(@NotNull PsiFile file) {
            this.myCachedSettings = CodeStyleSettingsManager.getInstance(file.getProject()).getCurrentSettings();
            this.updateFor(file);
        }

        private void updateFor(@NotNull PsiFile file) {
            TransientCodeStyleSettings modifiableSettings = new TransientCodeStyleSettings(file, this.myCachedSettings);
            for (CodeStyleSettingsModifier modifier : CODE_STYLE_SETTINGS_MODIFIER_EP_NAME.getExtensionList()) {
                if (!modifier.modifySettings(modifiableSettings, file)) continue;
                LOG.debug("Modifier: " + modifier.getClass().getName());
                modifiableSettings.setModifier(modifier);
                this.myCachedSettings = modifiableSettings;
                break;
            }
        }

        @NotNull
        Object[] getDependencies() {
            Object[] objectArray;
            if (this.myCachedSettings instanceof TransientCodeStyleSettings) {
                objectArray = ((TransientCodeStyleSettings)this.myCachedSettings).getDependencies().toArray();
            } else {
                Object[] objectArray2 = new Object[1];
                objectArray = objectArray2;
                objectArray2[0] = this.myCachedSettings.getModificationTracker();
            }
            return objectArray;
        }

        @NotNull
        CodeStyleSettings getCachedSettings() {
            return this.myCachedSettings;
        }
    }
}

