/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.application.options.codeStyle.properties;

import com.intellij.application.options.codeStyle.properties.CodeStyleChoiceList;
import com.intellij.application.options.codeStyle.properties.ExternalStringAccessor;
import com.intellij.util.containers.BidirectionalMap;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class BraceStyleAccessor
extends ExternalStringAccessor<Integer>
implements CodeStyleChoiceList {
    private static final BidirectionalMap<Integer, String> BRACE_STYLE_MAP = new BidirectionalMap();
    public static final String VALUE_END_OF_LINE = "end_of_line";
    public static final String VALUE_NEXT_LINE = "next_line";
    public static final String VALUE_NEXT_LINE_IF_WRAPPED = "next_line_if_wrapped";
    public static final String VALUE_WHITESMITHS = "whitesmiths";
    public static final String VALUE_GNU = "gnu";
    private static final List<String> ALL_VALUES = Arrays.asList("end_of_line", "next_line", "whitesmiths", "gnu");

    BraceStyleAccessor(@NotNull Object object, @NotNull Field field) {
        super(object, field);
    }

    @Override
    @Nullable
    protected Integer fromExternal(@NotNull String str) {
        List keys = BRACE_STYLE_MAP.getKeysByValue((Object)str);
        return keys != null && keys.size() > 0 ? (Integer)keys.get(0) : null;
    }

    @Override
    @NotNull
    protected String toExternal(@NotNull Integer value) {
        return (String)BRACE_STYLE_MAP.get((Object)value);
    }

    @Override
    @NotNull
    public List<String> getChoices() {
        return ALL_VALUES;
    }

    static {
        BRACE_STYLE_MAP.put((Object)1, (Object)VALUE_END_OF_LINE);
        BRACE_STYLE_MAP.put((Object)2, (Object)VALUE_NEXT_LINE);
        BRACE_STYLE_MAP.put((Object)5, (Object)VALUE_NEXT_LINE_IF_WRAPPED);
        BRACE_STYLE_MAP.put((Object)3, (Object)VALUE_WHITESMITHS);
        BRACE_STYLE_MAP.put((Object)4, (Object)VALUE_GNU);
    }
}

