/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.application.options.codeStyle.properties;

import com.intellij.application.options.codeStyle.properties.CodeStylePropertyAccessor;
import com.intellij.application.options.codeStyle.properties.PropertyNameUtil;
import com.intellij.configurationStore.Property;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import java.lang.reflect.Field;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Experimental
public abstract class CodeStyleFieldAccessor<T, V>
extends CodeStylePropertyAccessor<V> {
    private final Object myObject;
    private final Field myField;

    public CodeStyleFieldAccessor(@NotNull Object object, @NotNull Field field) {
        this.myObject = object;
        this.myField = field;
    }

    @Override
    public boolean set(@NotNull V extVal) {
        try {
            T value = this.fromExternal(extVal);
            if (value != null) {
                this.myField.set(this.myObject, value);
                return true;
            }
        }
        catch (IllegalAccessException illegalAccessException) {
            // empty catch block
        }
        return false;
    }

    @Override
    @Nullable
    public V get() {
        try {
            Object value = this.myField.get(this.myObject);
            return value != null && !this.isEmpty(value) ? (V)this.toExternal(value) : null;
        }
        catch (IllegalAccessException illegalAccessException) {
            return null;
        }
    }

    @NotNull
    public Class getObjectClass() {
        return this.myObject.getClass();
    }

    protected boolean isEmpty(@NotNull T value) {
        return false;
    }

    @Nullable
    protected abstract T fromExternal(@NotNull V var1);

    @NotNull
    protected abstract V toExternal(@NotNull T var1);

    @Override
    public String getPropertyName() {
        String externalName;
        Property descriptor = this.myField.getAnnotation(Property.class);
        if (descriptor != null && !StringUtil.isEmpty((String)(externalName = descriptor.externalName()))) {
            return externalName;
        }
        return PropertyNameUtil.getPropertyName(this.myField.getName());
    }

    @Override
    public boolean isGenericProperty() {
        return this.myObject instanceof CommonCodeStyleSettings || this.myObject instanceof CommonCodeStyleSettings.IndentOptions;
    }
}

