/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.application.options.codeStyle.properties;

import com.intellij.application.options.codeStyle.properties.CodeStyleChoiceList;
import com.intellij.application.options.codeStyle.properties.ExternalStringAccessor;
import com.intellij.util.containers.BidirectionalMap;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EnumPropertyAccessor
extends ExternalStringAccessor<Enum>
implements CodeStyleChoiceList {
    private final Class myEnumClass;
    private final BidirectionalMap<String, Enum> myEnumMap = new BidirectionalMap();

    public EnumPropertyAccessor(@NotNull Object object, @NotNull Field field) {
        super(object, field);
        this.myEnumClass = field.getType();
        this.fillEnumMap();
    }

    private void fillEnumMap() {
        T[] enumConstants = this.myEnumClass.getEnumConstants();
        if (enumConstants != null) {
            for (Object enumConstant : enumConstants) {
                this.myEnumMap.put((Object)enumConstant.toString().toLowerCase(Locale.ENGLISH), (Object)((Enum)enumConstant));
            }
        }
    }

    @Override
    @NotNull
    public List<String> getChoices() {
        return new ArrayList<String>(this.myEnumMap.keySet());
    }

    @Override
    @Nullable
    protected Enum fromExternal(@NotNull String str) {
        return (Enum)this.myEnumMap.get((Object)str);
    }

    @Override
    @NotNull
    protected String toExternal(@NotNull Enum value) {
        List names = this.myEnumMap.getKeysByValue((Object)value);
        assert (names != null && names.size() > 0) : "Unexpected value " + value.toString();
        return (String)names.get(0);
    }
}

