/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.application.options.codeStyle.properties;

import com.intellij.application.options.codeStyle.properties.CodeStyleChoiceList;
import com.intellij.application.options.codeStyle.properties.ExternalStringAccessor;
import com.intellij.util.containers.BidirectionalMap;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class ForceBracesAccessor
extends ExternalStringAccessor<Integer>
implements CodeStyleChoiceList {
    private static final BidirectionalMap<Integer, String> FORCE_BRACES_MAP = new BidirectionalMap();
    public static final String VALUE_NEVER = "never";
    public static final String VALUE_MULTILINE = "if_multiline";
    public static final String VALUE_ALWAYS = "always";
    private static final List<String> ALL_VALUES = Arrays.asList("never", "if_multiline", "always");

    ForceBracesAccessor(@NotNull Object object, @NotNull Field field) {
        super(object, field);
    }

    @Override
    @Nullable
    protected Integer fromExternal(@NotNull String str) {
        List keys = FORCE_BRACES_MAP.getKeysByValue((Object)str);
        return keys != null && keys.size() > 0 ? (Integer)keys.get(0) : null;
    }

    @Override
    @NotNull
    protected String toExternal(@NotNull Integer value) {
        return (String)FORCE_BRACES_MAP.get((Object)value);
    }

    @Override
    @NotNull
    public List<String> getChoices() {
        return ALL_VALUES;
    }

    static {
        FORCE_BRACES_MAP.put((Object)0, (Object)VALUE_NEVER);
        FORCE_BRACES_MAP.put((Object)1, (Object)VALUE_MULTILINE);
        FORCE_BRACES_MAP.put((Object)3, (Object)VALUE_ALWAYS);
    }
}

