/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.application.options.codeStyle.properties;

import com.intellij.application.options.codeStyle.properties.AbstractCodeStylePropertyMapper;
import com.intellij.application.options.codeStyle.properties.CodeStylePropertyAccessor;
import com.intellij.application.options.codeStyle.properties.StringAccessor;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.options.OptionsBundle;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.util.containers.ContainerUtil;
import java.lang.reflect.Field;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GeneralCodeStylePropertyMapper
extends AbstractCodeStylePropertyMapper {
    private static final Logger LOG = Logger.getInstance(AbstractCodeStylePropertyMapper.class);
    public static final String COMMON_DOMAIN_ID = "all";
    private static final Set<String> GENERAL_FIELDS = ContainerUtil.newHashSet((Object[])new String[]{"LINE_SEPARATOR", "RIGHT_MARGIN", "WRAP_WHEN_TYPING_REACHES_RIGHT_MARGIN", "FORMATTER_TAGS_ENABLED", "FORMATTER_ON_TAG", "FORMATTER_OFF_TAG", "FORMATTER_TAGS_ACCEPT_REGEXP"});

    public GeneralCodeStylePropertyMapper(@NotNull CodeStyleSettings settings) {
        super(settings);
    }

    @Override
    @NotNull
    protected List<AbstractCodeStylePropertyMapper.CodeStyleObjectDescriptor> getSupportedFields() {
        return Collections.singletonList(new AbstractCodeStylePropertyMapper.CodeStyleObjectDescriptor(this.getRootSettings(), GENERAL_FIELDS));
    }

    @Override
    protected boolean useDeclaredFields() {
        return true;
    }

    @Override
    @NotNull
    public String getLanguageDomainId() {
        return COMMON_DOMAIN_ID;
    }

    @Override
    @Nullable
    protected CodeStylePropertyAccessor getAccessor(@NotNull Object codeStyleObject, @NotNull Field field) {
        if (codeStyleObject instanceof CodeStyleSettings && "LINE_SEPARATOR".equals(field.getName())) {
            return new LineSeparatorAccessor(codeStyleObject, field);
        }
        return super.getAccessor(codeStyleObject, field);
    }

    @Override
    @Nullable
    public String getPropertyDescription(@NotNull String externalName) {
        String key = "codestyle.property.description." + externalName;
        return OptionsBundle.getBundle().containsKey(key) ? OptionsBundle.message("codestyle.property.description." + externalName, new Object[0]) : null;
    }

    private static class LineSeparatorAccessor
    extends StringAccessor {
        LineSeparatorAccessor(@NotNull Object object, @NotNull Field field) {
            super(object, field);
        }

        @Override
        @Nullable
        protected String fromExternal(@NotNull String str) {
            if (str.equals("lf")) {
                return "\n";
            }
            if (str.equals("cr")) {
                return "\r";
            }
            if (str.equals("crlf")) {
                return "\r\f";
            }
            return null;
        }

        @Override
        @NotNull
        protected String toExternal(@NotNull String value) {
            if ("\n".equals(value)) {
                return "lf";
            }
            if ("\r".equals(value)) {
                return "cr";
            }
            if ("\r\n".equals(value)) {
                return "crlf";
            }
            LOG.error("Unexpected field value: " + value);
            return "";
        }

        @Override
        protected boolean isEmpty(@NotNull String value) {
            return StringUtil.isEmpty((String)value);
        }
    }
}

