/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.application.options.codeStyle.properties;

import com.intellij.application.options.IndentOptionsEditor;
import com.intellij.application.options.SmartIndentOptionsEditor;
import com.intellij.application.options.codeStyle.properties.AbstractCodeStylePropertyMapper;
import com.intellij.application.options.codeStyle.properties.CodeStyleFieldAccessor;
import com.intellij.application.options.codeStyle.properties.CodeStylePropertyAccessor;
import com.intellij.lang.Language;
import com.intellij.openapi.options.OptionsBundle;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.CodeStyleSettingsProvider;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import com.intellij.psi.codeStyle.CustomCodeStyleSettings;
import com.intellij.psi.codeStyle.LanguageCodeStyleSettingsProvider;
import com.intellij.util.containers.ContainerUtil;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Experimental
public final class LanguageCodeStylePropertyMapper
extends AbstractCodeStylePropertyMapper {
    @NotNull
    private final Language myLanguage;
    @NotNull
    private final String myLanguageDomainId;
    @Nullable
    private final LanguageCodeStyleSettingsProvider mySettingsProvider;
    @NotNull
    private final List<CustomCodeStyleSettings> myCustomSettings;

    public LanguageCodeStylePropertyMapper(@NotNull CodeStyleSettings settings, @NotNull Language language, @Nullable String languageDomainId) {
        super(settings);
        this.myLanguage = language;
        this.myLanguageDomainId = languageDomainId == null ? this.myLanguage.getID().toLowerCase(Locale.ENGLISH) : languageDomainId;
        this.mySettingsProvider = LanguageCodeStyleSettingsProvider.forLanguage(language);
        this.myCustomSettings = this.getCustomSettings();
    }

    @Override
    @Nullable
    protected CodeStylePropertyAccessor getAccessor(@NotNull Object codeStyleObject, @NotNull Field field) {
        CodeStyleFieldAccessor accessor;
        CodeStyleFieldAccessor codeStyleFieldAccessor = accessor = this.mySettingsProvider != null ? this.mySettingsProvider.getAccessor(codeStyleObject, field) : null;
        if (accessor != null) {
            return accessor;
        }
        return super.getAccessor(codeStyleObject, field);
    }

    @Override
    protected void addAdditionalAccessors(@NotNull Map<String, CodeStylePropertyAccessor> accessorMap) {
        if (this.mySettingsProvider != null) {
            for (CustomCodeStyleSettings customSettings : this.myCustomSettings) {
                for (CodeStylePropertyAccessor accessor : this.mySettingsProvider.getAdditionalAccessors(customSettings)) {
                    accessorMap.put(accessor.getPropertyName(), accessor);
                }
            }
        }
    }

    @Override
    @NotNull
    protected List<AbstractCodeStylePropertyMapper.CodeStyleObjectDescriptor> getSupportedFields() {
        ArrayList fieldsDescriptors = ContainerUtil.newArrayList();
        CommonCodeStyleSettings.IndentOptions indentOptions = this.getRootSettings().getCommonSettings(this.myLanguage).getIndentOptions();
        if (indentOptions != null) {
            fieldsDescriptors.add(new AbstractCodeStylePropertyMapper.CodeStyleObjectDescriptor(indentOptions, this.getSupportedIndentOptions()));
        }
        fieldsDescriptors.add(new AbstractCodeStylePropertyMapper.CodeStyleObjectDescriptor(this.getRootSettings().getCommonSettings(this.myLanguage), this.getSupportedLanguageFields()));
        for (CustomCodeStyleSettings customSettings : this.myCustomSettings) {
            fieldsDescriptors.add(new AbstractCodeStylePropertyMapper.CodeStyleObjectDescriptor(customSettings, null));
        }
        return fieldsDescriptors;
    }

    @NotNull
    public Language getLanguage() {
        return this.myLanguage;
    }

    @Override
    @NotNull
    public String getLanguageDomainId() {
        return this.myLanguageDomainId;
    }

    private List<CustomCodeStyleSettings> getCustomSettings() {
        ArrayList<CustomCodeStyleSettings> customSettingsList = new ArrayList<CustomCodeStyleSettings>();
        this.addCustomSettings(customSettingsList, this.getRootSettings(), CodeStyleSettingsProvider.EXTENSION_POINT_NAME.getExtensionList());
        this.addCustomSettings(customSettingsList, this.getRootSettings(), LanguageCodeStyleSettingsProvider.getSettingsPagesProviders());
        return customSettingsList;
    }

    private void addCustomSettings(@NotNull List<CustomCodeStyleSettings> list, @NotNull CodeStyleSettings rootSettings, @NotNull List<? extends CodeStyleSettingsProvider> providerList) {
        for (CodeStyleSettingsProvider codeStyleSettingsProvider : providerList) {
            CustomCodeStyleSettings customSettingsTemplate;
            if (codeStyleSettingsProvider.getLanguage() != this.myLanguage || (customSettingsTemplate = codeStyleSettingsProvider.createCustomSettings(rootSettings)) == null) continue;
            Object customSettings = rootSettings.getCustomSettings(customSettingsTemplate.getClass());
            list.add((CustomCodeStyleSettings)customSettings);
        }
    }

    private Set<String> getSupportedIndentOptions() {
        LanguageCodeStyleSettingsProvider provider = LanguageCodeStyleSettingsProvider.forLanguage(this.myLanguage);
        if (provider == null) {
            return Collections.emptySet();
        }
        HashSet indentOptions = ContainerUtil.newHashSet();
        IndentOptionsEditor editor = provider.getIndentOptionsEditor();
        if (editor != null) {
            indentOptions.add("TAB_SIZE");
            indentOptions.add("USE_TAB_CHARACTER");
            indentOptions.add("INDENT_SIZE");
            if (editor instanceof SmartIndentOptionsEditor) {
                indentOptions.add("CONTINUATION_INDENT_SIZE");
                indentOptions.add("SMART_TABS");
                indentOptions.add("KEEP_INDENTS_ON_EMPTY_LINES");
            }
        }
        return indentOptions;
    }

    private Set<String> getSupportedLanguageFields() {
        return this.mySettingsProvider == null ? Collections.emptySet() : this.mySettingsProvider.getSupportedFields();
    }

    @Override
    @Nullable
    public String getPropertyDescription(@NotNull String externalName) {
        String key = "codestyle.property.description." + externalName;
        return OptionsBundle.getBundle().containsKey(key) ? OptionsBundle.message(key, new Object[0]) : null;
    }
}

