/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.application.options.codeStyle.properties;

import com.intellij.application.options.codeStyle.properties.CodeStyleChoiceList;
import com.intellij.application.options.codeStyle.properties.ExternalStringAccessor;
import com.intellij.util.containers.BidirectionalMap;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class WrappingAccessor
extends ExternalStringAccessor<Integer>
implements CodeStyleChoiceList {
    private static final BidirectionalMap<Integer, String> WRAPPING_MAP = new BidirectionalMap();
    public static final String VALUE_OFF = "off";
    public static final String VALUE_NORMAL = "normal";
    public static final String VALUE_ON_EVERY_ITEM = "on_every_item";
    public static final String VALUE_SPLIT_INTO_LINES = "split_into_lines";
    public static final List<String> ALL_VALUES = Arrays.asList("off", "normal", "on_every_item", "split_into_lines");

    WrappingAccessor(@NotNull Object object, @NotNull Field field) {
        super(object, field);
    }

    @Override
    @Nullable
    protected Integer fromExternal(@NotNull String str) {
        List keys = WRAPPING_MAP.getKeysByValue((Object)str);
        return keys != null && keys.size() > 0 ? (Integer)keys.get(0) : null;
    }

    @Override
    @NotNull
    protected String toExternal(@NotNull Integer value) {
        return (String)WRAPPING_MAP.get((Object)value);
    }

    @Override
    @NotNull
    public List<String> getChoices() {
        return ALL_VALUES;
    }

    static {
        WRAPPING_MAP.put((Object)0, (Object)VALUE_OFF);
        WRAPPING_MAP.put((Object)1, (Object)VALUE_NORMAL);
        WRAPPING_MAP.put((Object)4, (Object)VALUE_ON_EVERY_ITEM);
        WRAPPING_MAP.put((Object)5, (Object)VALUE_ON_EVERY_ITEM);
        WRAPPING_MAP.put((Object)2, (Object)VALUE_SPLIT_INTO_LINES);
    }
}

