/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight;

import com.intellij.application.options.CodeStyle;
import com.intellij.codeInsight.CharTailType;
import com.intellij.codeInsight.completion.InsertionContext;
import com.intellij.lang.Language;
import com.intellij.openapi.editor.CaretModel;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.text.CharArrayUtil;
import org.jetbrains.annotations.NotNull;

public abstract class TailType {
    public static final TailType UNKNOWN = new TailType(){

        @Override
        public int processTail(Editor editor, int tailOffset) {
            return tailOffset;
        }

        public String toString() {
            return "UNKNOWN";
        }
    };
    public static final TailType NONE = new TailType(){

        @Override
        public int processTail(Editor editor, int tailOffset) {
            return tailOffset;
        }

        public String toString() {
            return "NONE";
        }
    };
    public static final TailType SEMICOLON = new CharTailType(';');
    public static final TailType COMMA = new TailType(){

        @Override
        public int processTail(Editor editor, int tailOffset) {
            CommonCodeStyleSettings styleSettings = 3.getLocalCodeStyleSettings(editor, tailOffset);
            if (styleSettings.SPACE_BEFORE_COMMA) {
                tailOffset = 3.insertChar(editor, tailOffset, ' ');
            }
            tailOffset = 3.insertChar(editor, tailOffset, ',');
            if (styleSettings.SPACE_AFTER_COMMA) {
                tailOffset = 3.insertChar(editor, tailOffset, ' ');
            }
            return tailOffset;
        }

        public String toString() {
            return "COMMA";
        }
    };
    public static final TailType SPACE = new CharTailType(' ');
    public static final TailType INSERT_SPACE = new CharTailType(' ', false);
    public static final TailType HUMBLE_SPACE_BEFORE_WORD = new CharTailType(' ', false){

        @Override
        public boolean isApplicable(@NotNull InsertionContext context) {
            CharSequence text = context.getDocument().getCharsSequence();
            int tail = context.getTailOffset();
            if (text.length() > tail + 1 && text.charAt(tail) == ' ' && Character.isLetter(text.charAt(tail + 1))) {
                return false;
            }
            return super.isApplicable(context);
        }

        @Override
        public String toString() {
            return "HUMBLE_SPACE_BEFORE_WORD";
        }
    };
    public static final TailType DOT = new CharTailType('.');
    public static final TailType CASE_COLON = new CharTailType(':');
    public static final TailType COND_EXPR_COLON = new TailType(){

        @Override
        public int processTail(Editor editor, int tailOffset) {
            Document document = editor.getDocument();
            int textLength = document.getTextLength();
            CharSequence chars = document.getCharsSequence();
            int afterWhitespace = CharArrayUtil.shiftForward((CharSequence)chars, (int)tailOffset, (String)" \n\t");
            if (afterWhitespace < textLength && chars.charAt(afterWhitespace) == ':') {
                return 5.moveCaret(editor, tailOffset, afterWhitespace - tailOffset + 1);
            }
            document.insertString(tailOffset, " : ");
            return 5.moveCaret(editor, tailOffset, 3);
        }

        public String toString() {
            return "COND_EXPR_COLON";
        }
    };
    public static final TailType EQ = new TailTypeEQ();
    public static final TailType LPARENTH = new CharTailType('(');

    public static int insertChar(Editor editor, int tailOffset, char c) {
        return TailType.insertChar(editor, tailOffset, c, true);
    }

    public static int insertChar(Editor editor, int tailOffset, char c, boolean overwrite) {
        Document document = editor.getDocument();
        int textLength = document.getTextLength();
        CharSequence chars = document.getCharsSequence();
        if (tailOffset == textLength || !overwrite || chars.charAt(tailOffset) != c) {
            document.insertString(tailOffset, String.valueOf(c));
        }
        return TailType.moveCaret(editor, tailOffset, 1);
    }

    protected static int moveCaret(Editor editor, int tailOffset, int delta) {
        CaretModel model = editor.getCaretModel();
        if (model.getOffset() == tailOffset) {
            model.moveToOffset(tailOffset + delta);
        }
        return tailOffset + delta;
    }

    protected static CommonCodeStyleSettings getLocalCodeStyleSettings(Editor editor, int tailOffset) {
        PsiFile psiFile = TailType.getFile(editor);
        Language language = PsiUtilCore.getLanguageAtOffset(psiFile, tailOffset);
        return CodeStyle.getLanguageSettings(psiFile, language);
    }

    protected static FileType getFileType(Editor editor) {
        PsiFile psiFile = TailType.getFile(editor);
        return psiFile.getFileType();
    }

    @NotNull
    private static PsiFile getFile(Editor editor) {
        Project project = editor.getProject();
        assert (project != null);
        PsiFile psiFile = PsiDocumentManager.getInstance(project).getPsiFile(editor.getDocument());
        assert (psiFile != null);
        return psiFile;
    }

    public abstract int processTail(Editor var1, int var2);

    public static TailType createSimpleTailType(char c) {
        return new CharTailType(c);
    }

    public boolean isApplicable(@NotNull InsertionContext context) {
        return true;
    }

    public static class TailTypeEQ
    extends TailType {
        protected boolean isSpaceAroundAssignmentOperators(Editor editor, int tailOffset) {
            return TailTypeEQ.getLocalCodeStyleSettings((Editor)editor, (int)tailOffset).SPACE_AROUND_ASSIGNMENT_OPERATORS;
        }

        @Override
        public int processTail(Editor editor, int tailOffset) {
            Document document = editor.getDocument();
            int textLength = document.getTextLength();
            CharSequence chars = document.getCharsSequence();
            if (tailOffset < textLength - 1 && chars.charAt(tailOffset) == ' ' && chars.charAt(tailOffset + 1) == '=') {
                return TailTypeEQ.moveCaret(editor, tailOffset, 2);
            }
            if (tailOffset < textLength && chars.charAt(tailOffset) == '=') {
                return TailTypeEQ.moveCaret(editor, tailOffset, 1);
            }
            if (this.isSpaceAroundAssignmentOperators(editor, tailOffset)) {
                document.insertString(tailOffset, " =");
                tailOffset = TailTypeEQ.moveCaret(editor, tailOffset, 2);
                tailOffset = TailTypeEQ.insertChar(editor, tailOffset, ' ');
            } else {
                document.insertString(tailOffset, "=");
                tailOffset = TailTypeEQ.moveCaret(editor, tailOffset, 1);
            }
            return tailOffset;
        }
    }
}

