/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.completion;

import com.intellij.lang.Language;
import com.intellij.lang.LanguageExtension;
import com.intellij.lang.MetaLanguage;
import gnu.trove.THashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

class CompletionExtension<T>
extends LanguageExtension<T> {
    CompletionExtension(String epName) {
        super(epName);
    }

    @Override
    @NotNull
    protected List<T> buildExtensions(@NotNull String stringKey, @NotNull Language key) {
        return this.buildExtensions(this.getAllBaseLanguageIdsWithAny(key));
    }

    @NotNull
    private Set<String> getAllBaseLanguageIdsWithAny(@NotNull Language key) {
        THashSet allowed = new THashSet();
        while (key != null) {
            allowed.add(this.keyToString(key));
            key = key.getBaseLanguage();
        }
        allowed.add("any");
        for (MetaLanguage metaLanguage : MetaLanguage.all()) {
            allowed.add(metaLanguage.getID());
        }
        return allowed;
    }
}

