/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.completion;

import com.intellij.codeInsight.completion.PlainPrefixMatcher;
import com.intellij.codeInsight.lookup.LookupElement;
import org.jetbrains.annotations.NotNull;

public abstract class PrefixMatcher {
    public static final PrefixMatcher ALWAYS_TRUE = new PlainPrefixMatcher("");
    protected final String myPrefix;

    protected PrefixMatcher(String prefix) {
        this.myPrefix = prefix;
    }

    public boolean prefixMatches(@NotNull LookupElement element) {
        for (String s : element.getAllLookupStrings()) {
            if (!this.prefixMatches(s)) continue;
            return true;
        }
        return false;
    }

    public boolean isStartMatch(LookupElement element) {
        for (String s : element.getAllLookupStrings()) {
            if (!this.isStartMatch(s)) continue;
            return true;
        }
        return false;
    }

    public boolean isStartMatch(String name) {
        return this.prefixMatches(name);
    }

    public abstract boolean prefixMatches(@NotNull String var1);

    @NotNull
    public final String getPrefix() {
        return this.myPrefix;
    }

    @NotNull
    public abstract PrefixMatcher cloneWithPrefix(@NotNull String var1);

    public int matchingDegree(String string) {
        return 0;
    }
}

