/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon;

import com.intellij.codeInsight.daemon.LineMarkerSettings;
import javax.swing.Icon;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class GutterIconDescriptor {
    @Nullable(value="null means disabled")
    @Nls(capitalization=Nls.Capitalization.Sentence)
    public abstract String getName();

    @Nullable
    public Icon getIcon() {
        return null;
    }

    public boolean isEnabledByDefault() {
        return true;
    }

    @NonNls
    public String getId() {
        return this.getClass().getName();
    }

    @NotNull
    public Option[] getOptions() {
        return Option.NO_OPTIONS;
    }

    public String toString() {
        return this.getName();
    }

    public static class Option
    extends GutterIconDescriptor {
        private static final Option[] NO_OPTIONS = new Option[0];
        private final String myId;
        private final String myName;
        private final Icon myIcon;

        public Option(@NotNull String id, @NotNull @Nls(capitalization=Nls.Capitalization.Sentence) String name, Icon icon) {
            this.myId = id;
            this.myName = name;
            this.myIcon = icon;
        }

        public boolean isEnabled() {
            return LineMarkerSettings.getSettings().isEnabled(this);
        }

        @Override
        @Nullable
        public Icon getIcon() {
            return this.myIcon;
        }

        @Override
        @NotNull
        public String getName() {
            return this.myName;
        }

        @Override
        public String getId() {
            return this.myId;
        }
    }
}

