/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon;

import com.intellij.codeInsight.daemon.GutterIconNavigationHandler;
import com.intellij.codeInsight.daemon.NavigateAction;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.markup.GutterIconRenderer;
import com.intellij.openapi.editor.markup.MarkupEditorFilter;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.editor.markup.SeparatorPlacement;
import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.util.Function;
import java.awt.Color;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LineMarkerInfo<T extends PsiElement> {
    private static final Logger LOG = Logger.getInstance(LineMarkerInfo.class);
    protected final Icon myIcon;
    private final SmartPsiElementPointer<T> elementRef;
    public final int startOffset;
    public final int endOffset;
    public Color separatorColor;
    public SeparatorPlacement separatorPlacement;
    public RangeHighlighter highlighter;
    public final int updatePass;
    @Nullable
    private final Function<? super T, String> myTooltipProvider;
    private AnAction myNavigateAction = new NavigateAction(this);
    @NotNull
    private final GutterIconRenderer.Alignment myIconAlignment;
    @Nullable
    private final GutterIconNavigationHandler<T> myNavigationHandler;

    public LineMarkerInfo(@NotNull T element, @NotNull TextRange range, Icon icon, @Nullable Function<? super T, String> tooltipProvider, @Nullable GutterIconNavigationHandler<T> navHandler, @NotNull GutterIconRenderer.Alignment alignment) {
        PsiElement firstChild;
        this.myIcon = icon;
        this.myTooltipProvider = tooltipProvider;
        this.myIconAlignment = alignment;
        PsiFile containingFile = element.getContainingFile();
        Project project = containingFile.getProject();
        if (!InjectedLanguageManager.getInstance(project).getTopLevelFile(containingFile).getTextRange().contains(range)) {
            throw new IllegalArgumentException("Range must be inside file offsets (" + containingFile.getTextRange() + ") but got: " + range);
        }
        this.elementRef = SmartPointerManager.getInstance(project).createSmartPsiElementPointer(element, containingFile);
        this.myNavigationHandler = navHandler;
        this.startOffset = range.getStartOffset();
        this.endOffset = range.getEndOffset();
        this.updatePass = 11;
        if (!(element instanceof PsiFile) && (firstChild = element.getFirstChild()) != null) {
            String msg = "Performance warning: LineMarker is supposed to be registered for leaf elements only, but got: " + element + " (" + element.getClass() + ") instead. First child: " + firstChild + " (" + firstChild.getClass() + ")\nPlease see LineMarkerProvider#getLineMarkerInfo(PsiElement) javadoc for detailed explanations.";
            if (ApplicationManager.getApplication().isUnitTestMode()) {
                LOG.error(msg);
            } else {
                LOG.warn(msg);
            }
        }
    }

    @Deprecated
    public LineMarkerInfo(@NotNull T element, @NotNull TextRange range, Icon icon, int updatePass, @Nullable Function<? super T, String> tooltipProvider, @Nullable GutterIconNavigationHandler<T> navHandler, @NotNull GutterIconRenderer.Alignment alignment) {
        this((T)element, range, icon, tooltipProvider, (GutterIconNavigationHandler<? super T>)navHandler, alignment);
    }

    @Deprecated
    public LineMarkerInfo(@NotNull T element, int startOffset, Icon icon, int updatePass, @Nullable Function<? super T, String> tooltipProvider, @Nullable GutterIconNavigationHandler<T> navHandler, @NotNull GutterIconRenderer.Alignment alignment) {
        this((T)element, new TextRange(startOffset, startOffset), icon, updatePass, tooltipProvider, (GutterIconNavigationHandler<? super T>)navHandler, alignment);
    }

    @Deprecated
    public LineMarkerInfo(@NotNull T element, int startOffset, Icon icon, int updatePass, @Nullable Function<? super T, String> tooltipProvider, @Nullable GutterIconNavigationHandler<T> navHandler) {
        this((T)element, startOffset, icon, updatePass, tooltipProvider, (GutterIconNavigationHandler<? super T>)navHandler, GutterIconRenderer.Alignment.RIGHT);
    }

    @Nullable
    public Icon getIcon() {
        return this.myIcon;
    }

    @Nullable
    public GutterIconRenderer createGutterRenderer() {
        if (this.myIcon == null) {
            return null;
        }
        return new LineMarkerGutterIconRenderer(this);
    }

    @Nullable
    public String getLineMarkerTooltip() {
        if (this.myTooltipProvider == null) {
            return null;
        }
        T element = this.getElement();
        return element == null || !element.isValid() ? null : (String)this.myTooltipProvider.fun(element);
    }

    @Nullable
    public T getElement() {
        return this.elementRef.getElement();
    }

    void setNavigateAction(@NotNull AnAction navigateAction) {
        this.myNavigateAction = navigateAction;
    }

    @NotNull
    public MarkupEditorFilter getEditorFilter() {
        return MarkupEditorFilter.EMPTY;
    }

    @Nullable
    public GutterIconNavigationHandler<T> getNavigationHandler() {
        return this.myNavigationHandler;
    }

    public String toString() {
        return "(" + this.startOffset + "," + this.endOffset + ") -> " + this.elementRef;
    }

    public static class LineMarkerGutterIconRenderer<T extends PsiElement>
    extends GutterIconRenderer {
        private final LineMarkerInfo<T> myInfo;

        public LineMarkerGutterIconRenderer(@NotNull LineMarkerInfo<T> info) {
            this.myInfo = info;
        }

        public LineMarkerInfo<T> getLineMarkerInfo() {
            return this.myInfo;
        }

        @Override
        @NotNull
        public Icon getIcon() {
            return this.myInfo.myIcon;
        }

        @Override
        public AnAction getClickAction() {
            return ((LineMarkerInfo)this.myInfo).myNavigateAction;
        }

        @Override
        public boolean isNavigateAction() {
            return ((LineMarkerInfo)this.myInfo).myNavigationHandler != null;
        }

        @Override
        public String getTooltipText() {
            try {
                return this.myInfo.getLineMarkerTooltip();
            }
            catch (IndexNotReadyException ignored) {
                return null;
            }
        }

        @Override
        @NotNull
        public GutterIconRenderer.Alignment getAlignment() {
            return ((LineMarkerInfo)this.myInfo).myIconAlignment;
        }

        protected boolean looksTheSameAs(@NotNull LineMarkerGutterIconRenderer renderer) {
            return this.myInfo.getElement() != null && renderer.myInfo.getElement() != null && this.myInfo.getElement() == renderer.myInfo.getElement() && Comparing.equal((Object)((LineMarkerInfo)this.myInfo).myTooltipProvider, (Object)((LineMarkerInfo)renderer.myInfo).myTooltipProvider) && Comparing.equal((Object)this.myInfo.myIcon, (Object)renderer.myInfo.myIcon);
        }

        @Override
        public boolean equals(Object obj) {
            return obj instanceof LineMarkerGutterIconRenderer && this.looksTheSameAs((LineMarkerGutterIconRenderer)obj);
        }

        @Override
        public int hashCode() {
            T element = this.myInfo.getElement();
            return element == null ? 0 : element.hashCode();
        }
    }
}

