/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.intention.impl;

import com.intellij.codeInsight.intention.HighPriorityAction;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInsight.intention.LowPriorityAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class PriorityIntentionActionWrapper
implements IntentionAction {
    private final IntentionAction action;

    private PriorityIntentionActionWrapper(@NotNull IntentionAction action) {
        this.action = action;
    }

    @Override
    @NotNull
    public String getText() {
        return this.action.getText();
    }

    @Override
    @NotNull
    public String getFamilyName() {
        return this.action.getFamilyName();
    }

    @Override
    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
        return this.action.isAvailable(project, editor, file);
    }

    @Override
    public void invoke(@NotNull Project project, Editor editor, PsiFile file) throws IncorrectOperationException {
        this.action.invoke(project, editor, file);
    }

    @Override
    @Nullable
    public PsiElement getElementToMakeWritable(@NotNull PsiFile file) {
        return this.action.getElementToMakeWritable(file);
    }

    @Override
    public boolean startInWriteAction() {
        return this.action.startInWriteAction();
    }

    @NotNull
    public static IntentionAction highPriority(@NotNull IntentionAction action) {
        return new HighPriorityIntentionActionWrapper(action);
    }

    @NotNull
    public static IntentionAction normalPriority(@NotNull IntentionAction action) {
        return new NormalPriorityIntentionActionWrapper(action);
    }

    @NotNull
    public static IntentionAction lowPriority(@NotNull IntentionAction action) {
        return new LowPriorityIntentionActionWrapper(action);
    }

    private static class LowPriorityIntentionActionWrapper
    extends PriorityIntentionActionWrapper
    implements LowPriorityAction {
        protected LowPriorityIntentionActionWrapper(@NotNull IntentionAction action) {
            super(action);
        }
    }

    private static class NormalPriorityIntentionActionWrapper
    extends PriorityIntentionActionWrapper {
        protected NormalPriorityIntentionActionWrapper(@NotNull IntentionAction action) {
            super(action);
        }
    }

    private static class HighPriorityIntentionActionWrapper
    extends PriorityIntentionActionWrapper
    implements HighPriorityAction {
        protected HighPriorityIntentionActionWrapper(@NotNull IntentionAction action) {
            super(action);
        }
    }
}

