/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.lookup;

import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.JBColor;
import com.intellij.util.SmartList;
import java.awt.Color;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LookupElementPresentation {
    private Icon myIcon;
    private Icon myTypeIcon;
    private boolean myTypeIconRightAligned;
    private String myItemText;
    private String myTypeText;
    private boolean myStrikeout;
    private Color myItemTextForeground = JBColor.namedColor((String)"CompletionPopup.foreground", (Color)JBColor.foreground());
    private boolean myItemTextBold;
    private boolean myItemTextUnderlined;
    private boolean myItemTextItalic;
    private boolean myTypeGrayed;
    @Nullable
    private List<TextFragment> myTail;

    public void setIcon(@Nullable Icon icon) {
        this.myIcon = icon;
    }

    public void setItemText(@Nullable String text) {
        this.myItemText = text;
    }

    public void setStrikeout(boolean strikeout) {
        this.myStrikeout = strikeout;
    }

    public void setItemTextBold(boolean bold) {
        this.myItemTextBold = bold;
    }

    public void setItemTextItalic(boolean itemTextItalic) {
        this.myItemTextItalic = itemTextItalic;
    }

    public void setTailText(@Nullable String text) {
        this.setTailText(text, false);
    }

    public void clearTail() {
        this.myTail = null;
    }

    public void appendTailText(@NotNull String text, boolean grayed) {
        this.appendTailText(new TextFragment(text, grayed, false, null));
    }

    public void appendTailTextItalic(@NotNull String text, boolean grayed) {
        this.appendTailText(new TextFragment(text, grayed, true, null));
    }

    private void appendTailText(@NotNull TextFragment fragment) {
        if (this.myTail == null) {
            this.myTail = new SmartList();
        }
        this.myTail.add(fragment);
    }

    public void setTailText(@Nullable String text, boolean grayed) {
        this.clearTail();
        if (text != null) {
            this.appendTailText(new TextFragment(text, grayed, false, null));
        }
    }

    public void setTailText(@Nullable String text, @Nullable Color foreground) {
        this.clearTail();
        if (text != null) {
            this.appendTailText(new TextFragment(text, false, false, foreground));
        }
    }

    public void setTypeText(@Nullable String text) {
        this.setTypeText(text, null);
    }

    public void setTypeText(@Nullable String text, @Nullable Icon icon) {
        this.myTypeText = text;
        this.myTypeIcon = icon;
    }

    public boolean isReal() {
        return false;
    }

    @Nullable
    public Icon getIcon() {
        return this.myIcon;
    }

    @Nullable
    public Icon getTypeIcon() {
        return this.myTypeIcon;
    }

    @Nullable
    public String getItemText() {
        return this.myItemText;
    }

    @NotNull
    public List<TextFragment> getTailFragments() {
        return this.myTail == null ? Collections.emptyList() : Collections.unmodifiableList(this.myTail);
    }

    @Nullable
    public String getTailText() {
        if (this.myTail == null) {
            return null;
        }
        return StringUtil.join(this.myTail, fragment -> fragment.text, (String)"");
    }

    @Nullable
    public String getTypeText() {
        return this.myTypeText;
    }

    public boolean isStrikeout() {
        return this.myStrikeout;
    }

    @Deprecated
    public boolean isTailGrayed() {
        return this.myTail != null && this.myTail.get(0).myGrayed;
    }

    public boolean isItemTextBold() {
        return this.myItemTextBold;
    }

    public boolean isItemTextItalic() {
        return this.myItemTextItalic;
    }

    public boolean isItemTextUnderlined() {
        return this.myItemTextUnderlined;
    }

    public void setItemTextUnderlined(boolean itemTextUnderlined) {
        this.myItemTextUnderlined = itemTextUnderlined;
    }

    @NotNull
    public Color getItemTextForeground() {
        return this.myItemTextForeground;
    }

    public void setItemTextForeground(@NotNull Color itemTextForeground) {
        this.myItemTextForeground = itemTextForeground;
    }

    public void copyFrom(@NotNull LookupElementPresentation presentation) {
        this.myIcon = presentation.myIcon;
        this.myTypeIcon = presentation.myTypeIcon;
        this.myItemText = presentation.myItemText;
        List<TextFragment> thatTail = presentation.myTail;
        this.myTail = thatTail == null ? null : new SmartList(thatTail);
        this.myTypeText = presentation.myTypeText;
        this.myStrikeout = presentation.myStrikeout;
        this.myItemTextBold = presentation.myItemTextBold;
        this.myItemTextItalic = presentation.myItemTextItalic;
        this.myTypeGrayed = presentation.myTypeGrayed;
        this.myTypeIconRightAligned = presentation.myTypeIconRightAligned;
        this.myItemTextUnderlined = presentation.myItemTextUnderlined;
        this.myItemTextForeground = presentation.myItemTextForeground;
    }

    public boolean isTypeGrayed() {
        return this.myTypeGrayed;
    }

    public void setTypeGrayed(boolean typeGrayed) {
        this.myTypeGrayed = typeGrayed;
    }

    public boolean isTypeIconRightAligned() {
        return this.myTypeIconRightAligned;
    }

    public void setTypeIconRightAligned(boolean typeIconRightAligned) {
        this.myTypeIconRightAligned = typeIconRightAligned;
    }

    public static LookupElementPresentation renderElement(LookupElement element) {
        LookupElementPresentation presentation = new LookupElementPresentation();
        element.renderElement(presentation);
        return presentation;
    }

    public String toString() {
        return "LookupElementPresentation{itemText='" + this.myItemText + '\'' + ", tail=" + this.myTail + ", typeText='" + this.myTypeText + '\'' + '}';
    }

    public static class TextFragment {
        public final String text;
        private final boolean myGrayed;
        private final boolean myItalic;
        @Nullable
        private final Color myFgColor;

        private TextFragment(String text, boolean grayed, boolean italic, @Nullable Color fgColor) {
            this.text = text;
            this.myGrayed = grayed;
            this.myItalic = italic;
            this.myFgColor = fgColor;
        }

        public String toString() {
            return "TextFragment{text='" + this.text + '\'' + ", grayed=" + this.myGrayed + ", fgColor=" + this.myFgColor + '}';
        }

        public boolean isGrayed() {
            return this.myGrayed;
        }

        public boolean isItalic() {
            return this.myItalic;
        }

        @Nullable
        public Color getForegroundColor() {
            return this.myFgColor;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof TextFragment)) {
                return false;
            }
            TextFragment fragment = (TextFragment)o;
            return this.myGrayed == fragment.myGrayed && this.myItalic == fragment.myItalic && Objects.equals(this.text, fragment.text) && Objects.equals(this.myFgColor, fragment.myFgColor);
        }

        public int hashCode() {
            return Objects.hash(this.text, this.myGrayed, this.myItalic, this.myFgColor);
        }
    }
}

