/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection;

import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiRecursiveElementWalkingVisitor;
import com.intellij.psi.PsiRecursiveVisitor;
import java.util.List;
import java.util.regex.Pattern;
import org.intellij.lang.annotations.Language;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class LocalInspectionTool
extends InspectionProfileEntry {
    public static final LocalInspectionTool[] EMPTY_ARRAY = new LocalInspectionTool[0];
    private static final Logger LOG = Logger.getInstance(LocalInspectionTool.class);
    @NonNls
    @Language(value="RegExp")
    public static final String VALID_ID_PATTERN = "[a-zA-Z_0-9.-]+";
    private static final Pattern COMPILED_VALID_ID_PATTERN = Pattern.compile("[a-zA-Z_0-9.-]+");

    public static boolean isValidID(@NotNull String id) {
        return !id.isEmpty() && COMPILED_VALID_ID_PATTERN.matcher(id).matches();
    }

    @org.intellij.lang.annotations.Pattern(value="[a-zA-Z_0-9.-]+")
    @NonNls
    @NotNull
    public String getID() {
        String id;
        if (this.myNameProvider instanceof LocalDefaultNameProvider && (id = ((LocalDefaultNameProvider)this.myNameProvider).getDefaultID()) != null) {
            return id;
        }
        return this.getShortName();
    }

    @Override
    @NotNull
    protected final String getSuppressId() {
        return this.getID();
    }

    @Override
    @NonNls
    @Nullable
    public String getAlternativeID() {
        if (this.myNameProvider instanceof LocalDefaultNameProvider) {
            return ((LocalDefaultNameProvider)this.myNameProvider).getDefaultAlternativeID();
        }
        return null;
    }

    public boolean runForWholeFile() {
        return false;
    }

    @Nullable
    public ProblemDescriptor[] checkFile(@NotNull PsiFile file, @NotNull InspectionManager manager, boolean isOnTheFly) {
        return null;
    }

    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly, @NotNull LocalInspectionToolSession session) {
        return this.buildVisitor(holder, isOnTheFly);
    }

    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, final boolean isOnTheFly) {
        return new PsiElementVisitor(){

            @Override
            public void visitFile(PsiFile file) {
                this.addDescriptors(LocalInspectionTool.this.checkFile(file, holder.getManager(), isOnTheFly));
            }

            private void addDescriptors(ProblemDescriptor[] descriptors) {
                if (descriptors != null) {
                    for (ProblemDescriptor descriptor : descriptors) {
                        LOG.assertTrue(descriptor != null, (Object)LocalInspectionTool.this.getClass().getName());
                        holder.registerProblem(descriptor);
                    }
                }
            }
        };
    }

    @Nullable
    public PsiNamedElement getProblemElement(@NotNull PsiElement psiElement) {
        return psiElement.getContainingFile();
    }

    public void inspectionStarted(@NotNull LocalInspectionToolSession session, boolean isOnTheFly) {
    }

    public void inspectionFinished(@NotNull LocalInspectionToolSession session, @NotNull ProblemsHolder problemsHolder) {
        this.inspectionFinished(session);
    }

    @Deprecated
    public void inspectionFinished(@NotNull LocalInspectionToolSession session) {
    }

    @NotNull
    public List<ProblemDescriptor> processFile(@NotNull PsiFile file, @NotNull InspectionManager manager) {
        ProblemsHolder holder = new ProblemsHolder(manager, file, false);
        LocalInspectionToolSession session = new LocalInspectionToolSession(file, 0, file.getTextLength());
        final PsiElementVisitor customVisitor = this.buildVisitor(holder, false, session);
        LOG.assertTrue(!(customVisitor instanceof PsiRecursiveVisitor), (Object)("The visitor returned from LocalInspectionTool.buildVisitor() must not be recursive: " + customVisitor));
        this.inspectionStarted(session, false);
        final InjectedLanguageManager injectedLanguageManager = InjectedLanguageManager.getInstance(holder.getProject());
        file.accept(new PsiRecursiveElementWalkingVisitor(){

            @Override
            public void visitElement(PsiElement element) {
                element.accept(customVisitor);
                this.processInjectedFile(element);
                super.visitElement(element);
            }

            private void processInjectedFile(PsiElement element) {
                List<Pair<PsiElement, TextRange>> files;
                if (element instanceof PsiLanguageInjectionHost && (files = injectedLanguageManager.getInjectedPsiFiles(element)) != null) {
                    for (Pair<PsiElement, TextRange> pair : files) {
                        ((PsiElement)pair.first).accept(new PsiRecursiveElementWalkingVisitor(){

                            @Override
                            public void visitElement(PsiElement injectedElement) {
                                injectedElement.accept(customVisitor);
                                super.visitElement(injectedElement);
                            }
                        });
                    }
                }
            }
        });
        this.inspectionFinished(session, holder);
        return holder.getResults();
    }

    static interface LocalDefaultNameProvider
    extends InspectionProfileEntry.DefaultNameProvider {
        @Nullable
        public String getDefaultID();

        @Nullable
        public String getDefaultAlternativeID();
    }
}

