/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection;

import com.intellij.BundleBase;
import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInsight.daemon.EmptyResolveMessageProvider;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.LocalQuickFixProvider;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.ExternallyDefinedPsiElement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.xml.util.XmlStringUtil;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ProblemsHolder {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.codeInspection.ProblemsHolder");
    private final InspectionManager myManager;
    private final PsiFile myFile;
    private final boolean myOnTheFly;
    private final List<ProblemDescriptor> myProblems = new ArrayList<ProblemDescriptor>();

    public ProblemsHolder(@NotNull InspectionManager manager, @NotNull PsiFile file, boolean onTheFly) {
        this.myManager = manager;
        this.myFile = file;
        this.myOnTheFly = onTheFly;
    }

    public void registerProblem(@NotNull PsiElement psiElement, @NotNull @Nls(capitalization=Nls.Capitalization.Sentence) String descriptionTemplate, LocalQuickFix ... fixes) {
        this.registerProblem(psiElement, descriptionTemplate, ProblemHighlightType.GENERIC_ERROR_OR_WARNING, fixes);
    }

    public void registerProblem(@NotNull PsiElement psiElement, @NotNull @Nls(capitalization=Nls.Capitalization.Sentence) String descriptionTemplate, @NotNull ProblemHighlightType highlightType, LocalQuickFix ... fixes) {
        this.registerProblem(this.myManager.createProblemDescriptor(psiElement, descriptionTemplate, this.myOnTheFly, fixes, highlightType));
    }

    public void registerProblem(@NotNull ProblemDescriptor problemDescriptor) {
        PsiElement newTarget;
        ExternallyDefinedPsiElement external;
        PsiElement element = problemDescriptor.getPsiElement();
        if (element != null && !this.isInPsiFile(element) && (external = PsiTreeUtil.getParentOfType(element, ExternallyDefinedPsiElement.class, false)) != null && (newTarget = external.getProblemTarget()) != null) {
            this.redirectProblem(problemDescriptor, newTarget);
            return;
        }
        this.myProblems.add(problemDescriptor);
    }

    private boolean isInPsiFile(@NotNull PsiElement element) {
        PsiFile file = element.getContainingFile();
        return file != null && this.myFile.getViewProvider() == file.getViewProvider();
    }

    private void redirectProblem(@NotNull ProblemDescriptor problem, @NotNull PsiElement target) {
        PsiElement original = problem.getPsiElement();
        VirtualFile vFile = original.getContainingFile().getVirtualFile();
        assert (vFile != null);
        String path2 = FileUtil.toSystemIndependentName((String)vFile.getPath());
        String description = XmlStringUtil.stripHtml((String)problem.getDescriptionTemplate());
        String template = InspectionsBundle.message("inspection.redirect.template", description, path2, original.getTextRange().getStartOffset(), vFile.getName());
        InspectionManager manager = InspectionManager.getInstance(original.getProject());
        ProblemDescriptor newProblem = manager.createProblemDescriptor(target, template, (LocalQuickFix)null, problem.getHighlightType(), this.isOnTheFly());
        this.registerProblem(newProblem);
    }

    public void registerProblem(@NotNull PsiReference reference, String descriptionTemplate, ProblemHighlightType highlightType) {
        LocalQuickFix[] fixes = null;
        if (reference instanceof LocalQuickFixProvider) {
            fixes = ((LocalQuickFixProvider)((Object)reference)).getQuickFixes();
        }
        this.registerProblemForReference(reference, highlightType, descriptionTemplate, fixes);
    }

    public void registerProblemForReference(@NotNull PsiReference reference, @NotNull ProblemHighlightType highlightType, @NotNull String descriptionTemplate, LocalQuickFix ... fixes) {
        ProblemDescriptor descriptor = this.myManager.createProblemDescriptor(reference.getElement(), reference.getRangeInElement(), descriptionTemplate, highlightType, this.myOnTheFly, fixes);
        this.registerProblem(descriptor);
    }

    public void registerProblem(@NotNull PsiReference reference) {
        this.registerProblem(reference, ProblemsHolder.unresolvedReferenceMessage(reference), ProblemHighlightType.LIKE_UNKNOWN_SYMBOL);
    }

    public void registerProblem(@NotNull PsiReference reference, @NotNull ProblemHighlightType highlightType) {
        this.registerProblem(reference, ProblemsHolder.unresolvedReferenceMessage(reference), highlightType);
    }

    @NotNull
    public static String unresolvedReferenceMessage(@NotNull PsiReference reference) {
        String message;
        if (reference instanceof EmptyResolveMessageProvider) {
            String pattern = ((EmptyResolveMessageProvider)((Object)reference)).getUnresolvedMessagePattern();
            try {
                message = BundleBase.format((String)pattern, (Object[])new Object[]{reference.getCanonicalText()});
            }
            catch (IllegalArgumentException ex) {
                message = pattern;
                LOG.info(pattern);
            }
        } else {
            message = CodeInsightBundle.message("error.cannot.resolve.default.message", reference.getCanonicalText());
        }
        return message;
    }

    public void registerProblem(@NotNull PsiElement psiElement, @Nullable TextRange rangeInElement, @NotNull String message, LocalQuickFix ... fixes) {
        this.registerProblem(psiElement, message, ProblemHighlightType.GENERIC_ERROR_OR_WARNING, rangeInElement, fixes);
    }

    public void registerProblem(@NotNull PsiElement psiElement, @NotNull String message, @NotNull ProblemHighlightType highlightType, @Nullable TextRange rangeInElement, LocalQuickFix ... fixes) {
        this.registerProblem(this.myManager.createProblemDescriptor(psiElement, rangeInElement, message, highlightType, this.myOnTheFly, fixes));
    }

    @NotNull
    public List<ProblemDescriptor> getResults() {
        return this.myProblems;
    }

    @NotNull
    public ProblemDescriptor[] getResultsArray() {
        List<ProblemDescriptor> problems = this.getResults();
        return problems.toArray(ProblemDescriptor.EMPTY_ARRAY);
    }

    @NotNull
    public final InspectionManager getManager() {
        return this.myManager;
    }

    public boolean hasResults() {
        return !this.myProblems.isEmpty();
    }

    public int getResultCount() {
        return this.myProblems.size();
    }

    public boolean isOnTheFly() {
        return this.myOnTheFly;
    }

    @NotNull
    public PsiFile getFile() {
        return this.myFile;
    }

    @NotNull
    public final Project getProject() {
        return this.myManager.getProject();
    }
}

