/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.reference;

import com.intellij.codeInsight.daemon.ImplicitUsageProvider;
import com.intellij.codeInspection.ex.EntryPointsManager;
import com.intellij.codeInspection.reference.RefEntity;
import com.intellij.openapi.util.Comparing;
import com.intellij.psi.PsiElement;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;

public class RefUtil {
    private RefUtil() {
    }

    public static boolean isImplicitUsage(PsiElement element) {
        if (element == null) {
            return false;
        }
        for (ImplicitUsageProvider provider : ImplicitUsageProvider.EP_NAME.getExtensionList()) {
            if (!provider.isImplicitUsage(element)) continue;
            return true;
        }
        return false;
    }

    public static boolean isImplicitRead(PsiElement element) {
        if (element == null) {
            return false;
        }
        for (ImplicitUsageProvider provider : ImplicitUsageProvider.EP_NAME.getExtensionList()) {
            if (!provider.isImplicitRead(element)) continue;
            return true;
        }
        return false;
    }

    public static boolean contains(RefEntity element, @NotNull Collection<? extends RefEntity> entities) {
        for (RefEntity refEntity : entities) {
            if (!Comparing.equal((Object)refEntity, (Object)element)) continue;
            return true;
        }
        return false;
    }

    public static boolean isImplicitWrite(PsiElement element) {
        if (element == null) {
            return false;
        }
        for (ImplicitUsageProvider provider : ImplicitUsageProvider.EP_NAME.getExtensionList()) {
            if (!provider.isImplicitWrite(element)) continue;
            return true;
        }
        return EntryPointsManager.getInstance(element.getProject()).isImplicitWrite(element);
    }
}

