/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.chains;

import com.intellij.diff.chains.DiffRequestChainBase;
import com.intellij.diff.chains.DiffRequestProducer;
import com.intellij.diff.requests.DiffRequest;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class SimpleDiffRequestChain
extends DiffRequestChainBase {
    @NotNull
    private final List<DiffRequestProducerWrapper> myRequests;

    public SimpleDiffRequestChain(@NotNull DiffRequest request) {
        this(Collections.singletonList(request));
    }

    public SimpleDiffRequestChain(@NotNull List<? extends DiffRequest> requests) {
        this.myRequests = ContainerUtil.map(requests, request -> new DiffRequestProducerWrapper((DiffRequest)request));
    }

    @NotNull
    public List<DiffRequestProducerWrapper> getRequests() {
        return this.myRequests;
    }

    public static class DiffRequestProducerWrapper
    implements DiffRequestProducer {
        @NotNull
        private final DiffRequest myRequest;

        public DiffRequestProducerWrapper(@NotNull DiffRequest request) {
            this.myRequest = request;
        }

        @NotNull
        public DiffRequest getRequest() {
            return this.myRequest;
        }

        @Override
        @NotNull
        public String getName() {
            return StringUtil.notNullize((String)this.myRequest.getTitle(), (String)"Change");
        }

        @Override
        @NotNull
        public DiffRequest process(@NotNull UserDataHolder context, @NotNull ProgressIndicator indicator) throws ProcessCanceledException {
            return this.myRequest;
        }
    }
}

