/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.util;

import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import org.jetbrains.annotations.NotNull;

public class LineCol {
    public final int line;
    public final int column;

    public LineCol(int line) {
        this(line, 0);
    }

    public LineCol(int line, int column) {
        this.line = line;
        this.column = column;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LineCol col = (LineCol)o;
        if (this.line != col.line) {
            return false;
        }
        return this.column == col.column;
    }

    public int hashCode() {
        int result2 = this.line;
        result2 = 31 * result2 + this.column;
        return result2;
    }

    public String toString() {
        return String.format("{ line: %s, column: %s }", this.line, this.column);
    }

    @NotNull
    public static LineCol fromOffset(@NotNull Document document, int offset) {
        if (offset < document.getTextLength()) {
            int line = document.getLineNumber(offset);
            int column = offset - document.getLineStartOffset(line);
            return new LineCol(line, column);
        }
        int line = Math.max(0, document.getLineCount() - 1);
        int column = document.getLineEndOffset(line) - document.getLineStartOffset(line);
        return new LineCol(line, column);
    }

    @NotNull
    public static LineCol fromCaret(@NotNull Editor editor) {
        return LineCol.fromOffset(editor.getDocument(), editor.getCaretModel().getOffset());
    }

    public static int toOffset(@NotNull Document document, @NotNull LineCol linecol) {
        return linecol.toOffset(document);
    }

    public static int toOffset(@NotNull Document document, int line, int col) {
        return new LineCol(line, col).toOffset(document);
    }

    public int toOffset(@NotNull Document document) {
        if (this.line >= document.getLineCount()) {
            return document.getTextLength();
        }
        return Math.min(document.getLineStartOffset(this.line) + this.column, document.getLineEndOffset(this.line));
    }

    public int toOffset(@NotNull Editor editor) {
        return this.toOffset(editor.getDocument());
    }
}

