/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution;

import com.intellij.execution.DefaultExecutionTarget;
import com.intellij.execution.ExecutionTarget;
import com.intellij.execution.ExecutionTargetListener;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.project.Project;
import com.intellij.util.messages.Topic;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ExecutionTargetManager {
    public static final Topic<ExecutionTargetListener> TOPIC = Topic.create((String)"ExecutionTarget topic", ExecutionTargetListener.class);

    @NotNull
    public static ExecutionTargetManager getInstance(@NotNull Project project) {
        return ServiceManager.getService(project, ExecutionTargetManager.class);
    }

    @NotNull
    public static ExecutionTarget getActiveTarget(@NotNull Project project) {
        return ExecutionTargetManager.getInstance(project).getActiveTarget();
    }

    public static void setActiveTarget(@NotNull Project project, @NotNull ExecutionTarget target) {
        ExecutionTargetManager.getInstance(project).setActiveTarget(target);
    }

    @NotNull
    public static List<ExecutionTarget> getTargetsToChooseFor(@NotNull Project project, @Nullable RunConfiguration configuration) {
        List<ExecutionTarget> result2 = ExecutionTargetManager.getInstance(project).getTargetsFor(configuration);
        if ((result2 = Collections.unmodifiableList(result2.stream().filter(target -> !target.isExternallyManaged()).collect(Collectors.toList()))).size() == 1 && DefaultExecutionTarget.INSTANCE.equals(result2.get(0))) {
            return Collections.emptyList();
        }
        return result2;
    }

    @Deprecated
    public static boolean canRun(@Nullable RunnerAndConfigurationSettings settings, @Nullable ExecutionTarget target) {
        return ExecutionTargetManager.canRun(settings != null ? settings.getConfiguration() : null, target);
    }

    public static boolean canRun(@Nullable RunConfiguration configuration, @Nullable ExecutionTarget target) {
        if (configuration == null || target == null) {
            return false;
        }
        return ExecutionTargetManager.getInstance(configuration.getProject()).doCanRun(configuration, target);
    }

    public static boolean canRun(@NotNull ExecutionEnvironment environment) {
        RunnerAndConfigurationSettings settings = environment.getRunnerAndConfigurationSettings();
        return settings != null && ExecutionTargetManager.canRun(settings.getConfiguration(), environment.getExecutionTarget());
    }

    protected abstract boolean doCanRun(@Nullable RunConfiguration var1, @NotNull ExecutionTarget var2);

    public static void update(@NotNull Project project) {
        ExecutionTargetManager.getInstance(project).update();
    }

    @NotNull
    public abstract ExecutionTarget getActiveTarget();

    public abstract void setActiveTarget(@NotNull ExecutionTarget var1);

    @NotNull
    public abstract List<ExecutionTarget> getTargetsFor(@Nullable RunConfiguration var1);

    @Deprecated
    @NotNull
    public List<ExecutionTarget> getTargetsFor(@Nullable RunnerAndConfigurationSettings settings) {
        return this.getTargetsFor(settings == null ? null : settings.getConfiguration());
    }

    public abstract void update();
}

