/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution;

import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import javax.swing.Icon;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class Executor {
    public static final ExtensionPointName<Executor> EXECUTOR_EXTENSION_NAME = ExtensionPointName.create((String)"com.intellij.executor");

    public abstract String getToolWindowId();

    public abstract Icon getToolWindowIcon();

    @NotNull
    public abstract Icon getIcon();

    public abstract Icon getDisabledIcon();

    public abstract String getDescription();

    @NotNull
    public abstract String getActionName();

    @NotNull
    @NonNls
    public abstract String getId();

    @NotNull
    public abstract String getStartActionText();

    @NonNls
    public abstract String getContextActionId();

    @NonNls
    public abstract String getHelpId();

    @Nullable
    public ActionWrapper runnerActionsGroupExecutorActionCustomizer() {
        return null;
    }

    @NotNull
    public String getStartActionText(@NotNull String configurationName) {
        String configName;
        String text = this.getStartActionText();
        boolean hasMnemonic = text.indexOf(27) >= 0 || !StringUtil.escapeMnemonics((String)text).equals(text);
        String string = configName = StringUtil.isEmpty((String)configurationName) ? "" : " '" + Executor.shortenNameIfNeed(configurationName) + "'";
        if (!hasMnemonic) {
            configName = StringUtil.escapeMnemonics((String)configName);
        }
        return text + configName;
    }

    public boolean isApplicable(@NotNull Project project) {
        return true;
    }

    public static String shortenNameIfNeed(@NotNull String name) {
        return StringUtil.trimMiddle((String)name, (int)Registry.intValue((String)"run.configuration.max.name.length", (int)80));
    }

    @FunctionalInterface
    public static interface ActionWrapper {
        @NotNull
        public AnAction wrap(@NotNull AnAction var1);
    }
}

