/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution;

import com.intellij.execution.RunManagerKt;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.execution.configurations.ConfigurationType;
import com.intellij.execution.configurations.ConfigurationTypeUtil;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.configurations.RunProfile;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.text.StringKt;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.ReplaceWith;
import kotlin.TypeCastException;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.StringCompanionObject;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0011\n\u0002\b\u000f\n\u0002\u0018\u0002\n\u0002\b\u0007\b&\u0018\u0000 >2\u00020\u0001:\u0001>B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\tH&J\u0016\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\t2\u0006\u0010\u0015\u001a\u00020\u0016J\u0018\u0010\u0017\u001a\u00020\t2\u0006\u0010\u0018\u001a\u00020\u00052\u0006\u0010\u0019\u001a\u00020\u001aH&J\u0018\u0010\u0017\u001a\u00020\t2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u0019\u001a\u00020\u001aH&J\u001e\u0010\u0017\u001a\u00020\t2\u0006\u0010\u001b\u001a\u00020\u001c2\u000e\u0010\u001d\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u001f0\u001eJ\u0018\u0010 \u001a\u00020\t2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u0019\u001a\u00020\u001aH\u0007J\u0014\u0010!\u001a\u0004\u0018\u00010\t2\b\u0010\u001b\u001a\u0004\u0018\u00010\u001cH&J\u0018\u0010\"\u001a\u0004\u0018\u00010\t2\u0006\u0010#\u001a\u00020\u001f2\u0006\u0010\u001b\u001a\u00020\u001cJ\u0018\u0010\"\u001a\u0004\u0018\u00010\t2\u0006\u0010$\u001a\u00020\u001c2\u0006\u0010\u001b\u001a\u00020\u001cJ\u0012\u0010%\u001a\u0004\u0018\u00010\t2\u0006\u0010&\u001a\u00020\u0005H&J\u0013\u0010'\u001a\b\u0012\u0004\u0012\u00020\u00050(H\u0007\u00a2\u0006\u0002\u0010)J\u001b\u0010*\u001a\b\u0012\u0004\u0012\u00020\t0(2\u0006\u0010#\u001a\u00020\u001fH\u0007\u00a2\u0006\u0002\u0010+J\u0016\u0010,\u001a\b\u0012\u0004\u0012\u00020\t0\u00042\u0006\u0010#\u001a\u00020\u001fH&J\u001c\u0010,\u001a\b\u0012\u0004\u0012\u00020\t0\u00042\u000e\u0010#\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u001f0\u001eJ\u0010\u0010-\u001a\u00020\t2\u0006\u0010\u0019\u001a\u00020\u001aH&J\u0012\u0010.\u001a\u0004\u0018\u00010\u001f2\u0006\u0010/\u001a\u00020\u001cH\u0007J\u001b\u00100\u001a\b\u0012\u0004\u0012\u00020\u00050(2\u0006\u0010#\u001a\u00020\u001fH\u0007\u00a2\u0006\u0002\u00101J\u0016\u00102\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010#\u001a\u00020\u001fH&J\u0010\u00103\u001a\u00020\u00162\u0006\u0010\u0014\u001a\u00020\tH&J\u0010\u00104\u001a\u00020\u00162\u0006\u0010&\u001a\u00020\u0005H'J\u0010\u00105\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\tH&J\u0010\u00106\u001a\u00020\u00132\u0006\u00107\u001a\u000208H&J\u0012\u00109\u001a\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\tH&J\u0012\u0010:\u001a\u00020\u00132\b\u0010;\u001a\u0004\u0018\u00010\tH&J\u000e\u0010<\u001a\u00020\u00162\u0006\u0010\u0014\u001a\u00020\tJ\u000e\u0010<\u001a\u00020\u00162\u0006\u0010&\u001a\u00020\u0005J\u001a\u0010=\u001a\u00020\u001c2\b\u0010\u001b\u001a\u0004\u0018\u00010\u001c2\b\u0010#\u001a\u0004\u0018\u00010\u001fR\u0018\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R\u0018\u0010\b\u001a\b\u0012\u0004\u0012\u00020\t0\u0004X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u0007R\u001a\u0010\u000b\u001a\u0004\u0018\u00010\tX\u00a6\u000e\u00a2\u0006\f\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR\u0018\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\t0\u0004X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0007\u00a8\u0006?"}, d2={"Lcom/intellij/execution/RunManager;", "", "()V", "allConfigurationsList", "", "Lcom/intellij/execution/configurations/RunConfiguration;", "getAllConfigurationsList", "()Ljava/util/List;", "allSettings", "Lcom/intellij/execution/RunnerAndConfigurationSettings;", "getAllSettings", "selectedConfiguration", "getSelectedConfiguration", "()Lcom/intellij/execution/RunnerAndConfigurationSettings;", "setSelectedConfiguration", "(Lcom/intellij/execution/RunnerAndConfigurationSettings;)V", "tempConfigurationsList", "getTempConfigurationsList", "addConfiguration", "", "settings", "isShared", "", "createConfiguration", "runConfiguration", "factory", "Lcom/intellij/execution/configurations/ConfigurationFactory;", "name", "", "typeClass", "Ljava/lang/Class;", "Lcom/intellij/execution/configurations/ConfigurationType;", "createRunConfiguration", "findConfigurationByName", "findConfigurationByTypeAndName", "type", "typeId", "findSettings", "configuration", "getAllConfigurations", "", "()[Lcom/intellij/execution/configurations/RunConfiguration;", "getConfigurationSettings", "(Lcom/intellij/execution/configurations/ConfigurationType;)[Lcom/intellij/execution/RunnerAndConfigurationSettings;", "getConfigurationSettingsList", "getConfigurationTemplate", "getConfigurationType", "typeName", "getConfigurations", "(Lcom/intellij/execution/configurations/ConfigurationType;)[Lcom/intellij/execution/configurations/RunConfiguration;", "getConfigurationsList", "hasSettings", "isTemplate", "makeStable", "refreshUsagesList", "profile", "Lcom/intellij/execution/configurations/RunProfile;", "removeConfiguration", "setTemporaryConfiguration", "tempConfiguration", "setUniqueNameIfNeed", "suggestUniqueName", "Companion", "intellij.platform.lang"})
public abstract class RunManager {
    private static final Pattern UNIQUE_NAME_PATTERN;
    public static final Companion Companion;

    @Deprecated(message="", replaceWith=@ReplaceWith(imports={}, expression="getConfigurationsList(type)"))
    @NotNull
    public final RunConfiguration[] getConfigurations(@NotNull ConfigurationType type) {
        Collection $receiver$iv;
        Collection collection = $receiver$iv = (Collection)this.getConfigurationsList(type);
        if (collection == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.util.Collection<T>");
        }
        Collection thisCollection$iv = collection;
        RunConfiguration[] runConfigurationArray = thisCollection$iv.toArray(new RunConfiguration[0]);
        if (runConfigurationArray == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
        }
        return runConfigurationArray;
    }

    @NotNull
    public abstract List<RunConfiguration> getConfigurationsList(@NotNull ConfigurationType var1);

    @Deprecated(message="", replaceWith=@ReplaceWith(imports={}, expression="getConfigurationSettingsList(type)"))
    @NotNull
    public final RunnerAndConfigurationSettings[] getConfigurationSettings(@NotNull ConfigurationType type) {
        Collection $receiver$iv;
        Collection collection = $receiver$iv = (Collection)this.getConfigurationSettingsList(type);
        if (collection == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.util.Collection<T>");
        }
        Collection thisCollection$iv = collection;
        RunnerAndConfigurationSettings[] runnerAndConfigurationSettingsArray = thisCollection$iv.toArray(new RunnerAndConfigurationSettings[0]);
        if (runnerAndConfigurationSettingsArray == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
        }
        return runnerAndConfigurationSettingsArray;
    }

    @NotNull
    public abstract List<RunnerAndConfigurationSettings> getConfigurationSettingsList(@NotNull ConfigurationType var1);

    @NotNull
    public final List<RunnerAndConfigurationSettings> getConfigurationSettingsList(@NotNull Class<? extends ConfigurationType> type) {
        return this.getConfigurationSettingsList(ConfigurationTypeUtil.findConfigurationType(type));
    }

    @Deprecated(message="", replaceWith=@ReplaceWith(imports={}, expression="allConfigurationsList"))
    @NotNull
    public final RunConfiguration[] getAllConfigurations() {
        Collection $receiver$iv;
        Collection collection = $receiver$iv = (Collection)this.getAllConfigurationsList();
        if (collection == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.util.Collection<T>");
        }
        Collection thisCollection$iv = collection;
        RunConfiguration[] runConfigurationArray = thisCollection$iv.toArray(new RunConfiguration[0]);
        if (runConfigurationArray == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
        }
        return runConfigurationArray;
    }

    @NotNull
    public abstract List<RunConfiguration> getAllConfigurationsList();

    @NotNull
    public abstract List<RunnerAndConfigurationSettings> getAllSettings();

    @NotNull
    public abstract List<RunnerAndConfigurationSettings> getTempConfigurationsList();

    public abstract void makeStable(@NotNull RunnerAndConfigurationSettings var1);

    @Nullable
    public abstract RunnerAndConfigurationSettings getSelectedConfiguration();

    public abstract void setSelectedConfiguration(@Nullable RunnerAndConfigurationSettings var1);

    @NotNull
    public abstract RunnerAndConfigurationSettings createConfiguration(@NotNull String var1, @NotNull ConfigurationFactory var2);

    @NotNull
    public final RunnerAndConfigurationSettings createConfiguration(@NotNull String name, @NotNull Class<? extends ConfigurationType> typeClass) {
        return this.createConfiguration(name, (ConfigurationFactory)ArraysKt.first((Object[])ConfigurationTypeUtil.findConfigurationType(typeClass).getConfigurationFactories()));
    }

    @Deprecated(message="", replaceWith=@ReplaceWith(imports={}, expression="createConfiguration(name, factory)"))
    @NotNull
    public final RunnerAndConfigurationSettings createRunConfiguration(@NotNull String name, @NotNull ConfigurationFactory factory) {
        return this.createConfiguration(name, factory);
    }

    @NotNull
    public abstract RunnerAndConfigurationSettings createConfiguration(@NotNull RunConfiguration var1, @NotNull ConfigurationFactory var2);

    @NotNull
    public abstract RunnerAndConfigurationSettings getConfigurationTemplate(@NotNull ConfigurationFactory var1);

    public abstract void addConfiguration(@NotNull RunnerAndConfigurationSettings var1);

    public final void addConfiguration(@NotNull RunnerAndConfigurationSettings settings, boolean isShared) {
        settings.setShared(isShared);
        this.addConfiguration(settings);
    }

    public abstract void refreshUsagesList(@NotNull RunProfile var1);

    public abstract boolean hasSettings(@NotNull RunnerAndConfigurationSettings var1);

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final String suggestUniqueName(@Nullable String name, @Nullable ConfigurationType type) {
        Collection<String> collection;
        void $receiver$iv$iv;
        void $receiver$iv;
        List<RunnerAndConfigurationSettings> settingsList = type == null ? this.getAllSettings() : this.getConfigurationSettingsList(type);
        String string = StringKt.nullize$default(name, false, 1, null);
        if (string == null) {
            string = "Unnamed";
        }
        Iterable iterable = settingsList;
        String string2 = string;
        Companion companion = Companion;
        void var5_7 = $receiver$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            void it;
            RunnerAndConfigurationSettings runnerAndConfigurationSettings = (RunnerAndConfigurationSettings)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            String string3 = it.getName();
            collection.add(string3);
        }
        collection = (List)destination$iv$iv;
        return companion.suggestUniqueName(string2, collection);
    }

    public final boolean setUniqueNameIfNeed(@NotNull RunnerAndConfigurationSettings settings) {
        String oldName = settings.getName();
        settings.setName(this.suggestUniqueName(StringUtil.notNullize((String)oldName, (String)"Unnamed"), settings.getType()));
        return Intrinsics.areEqual((Object)oldName, (Object)settings.getName()) ^ true;
    }

    public final boolean setUniqueNameIfNeed(@NotNull RunConfiguration configuration) {
        String oldName = configuration.getName();
        configuration.setName(this.suggestUniqueName(StringUtil.notNullize((String)oldName, (String)"Unnamed"), configuration.getType()));
        return Intrinsics.areEqual((Object)oldName, (Object)configuration.getName()) ^ true;
    }

    @Deprecated(message="Use ConfigurationTypeUtil", replaceWith=@ReplaceWith(imports={"com.intellij.execution.configurations.ConfigurationTypeUtil"}, expression="ConfigurationTypeUtil.findConfigurationType(typeName)"))
    @Nullable
    public final ConfigurationType getConfigurationType(@NotNull String typeName) {
        return ConfigurationTypeUtil.findConfigurationType(typeName);
    }

    @Nullable
    public abstract RunnerAndConfigurationSettings findConfigurationByName(@Nullable String var1);

    @Nullable
    public abstract RunnerAndConfigurationSettings findSettings(@NotNull RunConfiguration var1);

    @Nullable
    public final RunnerAndConfigurationSettings findConfigurationByTypeAndName(@NotNull String typeId, @NotNull String name) {
        Object v0;
        block1: {
            Iterable $receiver$iv = this.getAllSettings();
            for (Object element$iv : $receiver$iv) {
                RunnerAndConfigurationSettings it = (RunnerAndConfigurationSettings)element$iv;
                boolean bl = false;
                if (!(Intrinsics.areEqual((Object)typeId, (Object)it.getType().getId()) && Intrinsics.areEqual((Object)name, (Object)it.getName()))) continue;
                v0 = element$iv;
                break block1;
            }
            v0 = null;
        }
        return v0;
    }

    @Nullable
    public final RunnerAndConfigurationSettings findConfigurationByTypeAndName(@NotNull ConfigurationType type, @NotNull String name) {
        Object v0;
        block1: {
            Iterable $receiver$iv = this.getAllSettings();
            for (Object element$iv : $receiver$iv) {
                RunnerAndConfigurationSettings it = (RunnerAndConfigurationSettings)element$iv;
                boolean bl = false;
                if (!(type == it.getType() && Intrinsics.areEqual((Object)name, (Object)it.getName()))) continue;
                v0 = element$iv;
                break block1;
            }
            v0 = null;
        }
        return v0;
    }

    public abstract void removeConfiguration(@Nullable RunnerAndConfigurationSettings var1);

    public abstract void setTemporaryConfiguration(@Nullable RunnerAndConfigurationSettings var1);

    @ApiStatus.Experimental
    public abstract boolean isTemplate(@NotNull RunConfiguration var1);

    static {
        Companion = new Companion(null);
        UNIQUE_NAME_PATTERN = Pattern.compile("(.*?)\\s*\\(\\d+\\)");
    }

    @JvmStatic
    @NotNull
    public static final RunManager getInstance(@NotNull Project project) {
        return Companion.getInstance(project);
    }

    @JvmStatic
    @NotNull
    public static final String suggestUniqueName(@NotNull String str, @NotNull Collection<String> currentNames) {
        return Companion.suggestUniqueName(str, currentNames);
    }

    @JvmStatic
    @NotNull
    public static final String extractBaseName(@NotNull String uniqueName) {
        return Companion.extractBaseName(uniqueName);
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u001e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0007H\u0007J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0007J\u001e\u0010\r\u001a\u00020\u00072\u0006\u0010\u000e\u001a\u00020\u00072\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00070\u0010H\u0007R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/intellij/execution/RunManager$Companion;", "", "()V", "UNIQUE_NAME_PATTERN", "Ljava/util/regex/Pattern;", "kotlin.jvm.PlatformType", "extractBaseName", "", "uniqueName", "getInstance", "Lcom/intellij/execution/RunManager;", "project", "Lcom/intellij/openapi/project/Project;", "suggestUniqueName", "str", "currentNames", "", "intellij.platform.lang"})
    public static final class Companion {
        @JvmStatic
        @NotNull
        public final RunManager getInstance(@NotNull Project project) {
            if (Intrinsics.areEqual((Object)((Boolean)RunManagerKt.getIS_RUN_MANAGER_INITIALIZED().get((UserDataHolder)project)), (Object)true) ^ true) {
                RunManagerKt.access$getLOG$p().debug("Must be not called before project components initialized");
            }
            return ServiceManager.getService(project, RunManager.class);
        }

        @JvmStatic
        @NotNull
        public final String suggestUniqueName(@NotNull String str, @NotNull Collection<String> currentNames) {
            if (!currentNames.contains(str)) {
                return str;
            }
            String originalName = this.extractBaseName(str);
            int i = 1;
            while (true) {
                String newName;
                StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
                String string = "%s (%d)";
                Object[] objectArray = new Object[]{originalName, i};
                Intrinsics.checkExpressionValueIsNotNull((Object)String.format(string, Arrays.copyOf(objectArray, objectArray.length)), (String)"java.lang.String.format(format, *args)");
                if (!currentNames.contains(newName)) {
                    return newName;
                }
                ++i;
            }
        }

        @JvmStatic
        @NotNull
        public final String extractBaseName(@NotNull String uniqueName) {
            Matcher matcher = UNIQUE_NAME_PATTERN.matcher(uniqueName);
            return matcher.matches() ? matcher.group(1) : uniqueName;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

