/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.JdkUtil;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;

public enum ShortenCommandLine {
    NONE("none", "java [options] classname [args]"),
    MANIFEST("JAR manifest", "java -cp classpath.jar classname [args]"),
    CLASSPATH_FILE("classpath file", "java WrapperClass classpathFile [args]"){

        @Override
        public boolean isApplicable(String jreRoot) {
            return jreRoot == null || !JdkUtil.isModularRuntime(jreRoot);
        }
    }
    ,
    ARGS_FILE("@argFiles (java 9+)", "java @argFile [args]"){

        @Override
        public boolean isApplicable(String jreRoot) {
            return jreRoot != null && JdkUtil.isModularRuntime(jreRoot);
        }
    };

    private final String myPresentableName;
    private final String myDescription;

    private ShortenCommandLine(String presentableName, String description) {
        this.myPresentableName = presentableName;
        this.myDescription = description;
    }

    public boolean isApplicable(String jreRoot) {
        return true;
    }

    public String getDescription() {
        return this.myDescription;
    }

    public String getPresentableName() {
        return this.myPresentableName;
    }

    public static ShortenCommandLine getDefaultMethod(Project project, String rootPath) {
        if (!JdkUtil.useDynamicClasspath(project)) {
            return NONE;
        }
        if (rootPath != null && JdkUtil.isModularRuntime(rootPath)) {
            return ARGS_FILE;
        }
        if (JdkUtil.useClasspathJar()) {
            return MANIFEST;
        }
        return CLASSPATH_FILE;
    }

    @Deprecated
    public static ShortenCommandLine readShortenClasspathMethod(@NotNull Element element) {
        Element mode = element.getChild("shortenClasspath");
        if (mode != null) {
            return ShortenCommandLine.valueOf(mode.getAttributeValue("name"));
        }
        return null;
    }

    @Deprecated
    public static void writeShortenClasspathMethod(@NotNull Element element, ShortenCommandLine shortenCommandLine) {
        if (shortenCommandLine != null) {
            element.addContent(new Element("shortenClasspath").setAttribute("name", shortenCommandLine.name()));
        }
    }
}

