/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.configurations;

import com.intellij.execution.BeforeRunTask;
import com.intellij.execution.RunManager;
import com.intellij.execution.configurations.ConfigurationType;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.configurations.RunConfigurationSingletonPolicy;
import com.intellij.openapi.components.BaseState;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.util.IconUtil;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ConfigurationFactory {
    private final ConfigurationType myType;

    protected ConfigurationFactory(@NotNull ConfigurationType type) {
        this.myType = type;
    }

    ConfigurationFactory() {
        this.myType = null;
    }

    @NotNull
    public RunConfiguration createConfiguration(@Nullable String name, @NotNull RunConfiguration template) {
        RunConfiguration newConfiguration = template.clone();
        newConfiguration.setName(name);
        return newConfiguration;
    }

    public boolean isApplicable(@NotNull Project project) {
        return true;
    }

    @NotNull
    public abstract RunConfiguration createTemplateConfiguration(@NotNull Project var1);

    @NotNull
    public RunConfiguration createTemplateConfiguration(@NotNull Project project, @NotNull RunManager runManager) {
        return this.createTemplateConfiguration(project);
    }

    @NotNull
    public String getId() {
        return this.getName();
    }

    @NotNull
    public String getName() {
        return this.myType.getDisplayName();
    }

    @Deprecated
    public Icon getAddIcon() {
        return IconUtil.getAddIcon();
    }

    public Icon getIcon(@NotNull RunConfiguration configuration) {
        return this.getIcon();
    }

    public Icon getIcon() {
        return this.myType.getIcon();
    }

    @NotNull
    public ConfigurationType getType() {
        return this.myType;
    }

    public void configureBeforeRunTaskDefaults(Key<? extends BeforeRunTask> providerID, BeforeRunTask task) {
    }

    @Deprecated
    public boolean isConfigurationSingletonByDefault() {
        return this.getSingletonPolicy() != RunConfigurationSingletonPolicy.MULTIPLE_INSTANCE;
    }

    @Deprecated
    public boolean canConfigurationBeSingleton() {
        return this.getSingletonPolicy() != RunConfigurationSingletonPolicy.SINGLE_INSTANCE_ONLY;
    }

    @NotNull
    public RunConfigurationSingletonPolicy getSingletonPolicy() {
        return RunConfigurationSingletonPolicy.SINGLE_INSTANCE;
    }

    @Nullable
    public Class<? extends BaseState> getOptionsClass() {
        return null;
    }
}

