/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.configurations;

import com.intellij.execution.configurations.ParamsGroup;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.PathMacros;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.EnvironmentUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.execution.ParametersListUtil;
import com.intellij.util.text.CaseInsensitiveStringHashingStrategy;
import gnu.trove.THashMap;
import gnu.trove.TObjectHashingStrategy;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ParametersList
implements Cloneable {
    private static final Pattern PROPERTY_PATTERN = Pattern.compile("-D(\\S+?)(?:=(.+))?");
    private static final Pattern MACRO_PATTERN = Pattern.compile("\\$\\{([^}]+)}");
    private final List<String> myParameters = new ArrayList<String>();
    private final List<ParamsGroup> myGroups = new SmartList();
    private final NotNullLazyValue<Map<String, String>> myMacroMap = NotNullLazyValue.createValue(ParametersList::computeMacroMap);
    private static Map<String, String> ourTestMacros;

    public boolean hasParameter(@NotNull String parameter) {
        return this.myParameters.contains(parameter);
    }

    public boolean hasProperty(@NotNull String propertyName) {
        return this.getPropertyValue(propertyName) != null;
    }

    @Nullable
    public String getPropertyValue(@NotNull String propertyName) {
        String prefix;
        String exact = "-D" + propertyName;
        int index2 = this.indexOfParameter((Condition<? super String>)((Condition)arg_0 -> ParametersList.lambda$getPropertyValue$0(exact, prefix = "-D" + propertyName + "=", arg_0)));
        if (index2 < 0) {
            return null;
        }
        String str = this.myParameters.get(index2);
        return str.length() == exact.length() ? "" : str.substring(prefix.length());
    }

    @NotNull
    public Map<String, String> getProperties() {
        return this.getProperties("");
    }

    @NotNull
    public Map<String, String> getProperties(String valueIfMissing) {
        LinkedHashMap<String, String> result2 = new LinkedHashMap<String, String>();
        JBIterable matchers = JBIterable.from(this.myParameters).map(PROPERTY_PATTERN::matcher).filter(Matcher::matches);
        for (Matcher matcher : matchers) {
            result2.put(matcher.group(1), StringUtil.notNullize((String)matcher.group(2), (String)valueIfMissing));
        }
        return result2;
    }

    @NotNull
    public String getParametersString() {
        return ParametersList.join(this.getList());
    }

    @NotNull
    public String[] getArray() {
        return ArrayUtil.toStringArray(this.getList());
    }

    @NotNull
    public List<String> getList() {
        if (this.myGroups.isEmpty()) {
            return Collections.unmodifiableList(this.myParameters);
        }
        ArrayList<String> params = new ArrayList<String>(this.myParameters);
        for (ParamsGroup group : this.myGroups) {
            params.addAll(group.getParameters());
        }
        return Collections.unmodifiableList(params);
    }

    public void clearAll() {
        this.myParameters.clear();
        this.myGroups.clear();
    }

    public void prepend(@NotNull String parameter) {
        this.addAt(0, parameter);
    }

    public void prependAll(String ... parameter) {
        this.addAll(parameter);
        Collections.rotate(this.myParameters, parameter.length);
    }

    public void addParametersString(@Nullable String parameters) {
        if (StringUtil.isEmptyOrSpaces((String)parameters)) {
            return;
        }
        for (String param : ParametersList.parse(parameters)) {
            this.add(param);
        }
    }

    public void add(@Nullable String parameter) {
        if (parameter == null) {
            return;
        }
        this.myParameters.add(this.expandMacros(parameter));
    }

    @NotNull
    public ParamsGroup addParamsGroup(@NotNull String groupId) {
        return this.addParamsGroup(new ParamsGroup(groupId));
    }

    @NotNull
    public ParamsGroup addParamsGroup(@NotNull ParamsGroup group) {
        this.myGroups.add(group);
        return group;
    }

    @NotNull
    public ParamsGroup addParamsGroupAt(int index2, @NotNull ParamsGroup group) {
        this.myGroups.add(index2, group);
        return group;
    }

    @NotNull
    public ParamsGroup addParamsGroupAt(int index2, @NotNull String groupId) {
        ParamsGroup group = new ParamsGroup(groupId);
        this.myGroups.add(index2, group);
        return group;
    }

    public int getParamsGroupsCount() {
        return this.myGroups.size();
    }

    @NotNull
    public List<String> getParameters() {
        return Collections.unmodifiableList(this.myParameters);
    }

    @NotNull
    public List<ParamsGroup> getParamsGroups() {
        return Collections.unmodifiableList(this.myGroups);
    }

    @NotNull
    public ParamsGroup getParamsGroupAt(int index2) {
        return this.myGroups.get(index2);
    }

    @Nullable
    public ParamsGroup getParamsGroup(@NotNull String name) {
        for (ParamsGroup group : this.myGroups) {
            if (!name.equals(group.getId())) continue;
            return group;
        }
        return null;
    }

    @Nullable
    public ParamsGroup removeParamsGroup(int index2) {
        return this.myGroups.remove(index2);
    }

    public void addAt(int index2, @NotNull String parameter) {
        this.myParameters.add(index2, this.expandMacros(parameter));
    }

    public void defineSystemProperty(@NotNull String propertyName) {
        this.defineProperty(propertyName, System.getProperty(propertyName));
    }

    public void defineProperty(@NotNull String propertyName, @Nullable String propertyValue) {
        String prefix;
        if (propertyValue == null) {
            return;
        }
        String exact = "-D" + propertyName;
        int index2 = this.indexOfParameter((Condition<? super String>)((Condition)arg_0 -> ParametersList.lambda$defineProperty$1(exact, prefix = "-D" + propertyName + "=", arg_0)));
        if (index2 > -1) {
            return;
        }
        String value = propertyValue.isEmpty() ? exact : prefix + this.expandMacros(propertyValue);
        this.myParameters.add(value);
    }

    public void addProperty(@NotNull String propertyName) {
        String exact = "-D" + propertyName;
        String prefix = "-D" + propertyName + "=";
        this.replaceOrAddAt(exact, this.myParameters.size(), (Condition<? super String>)((Condition)o -> o.equals(exact) || o.startsWith(prefix)));
    }

    public void addProperty(@NotNull String propertyName, @Nullable String propertyValue) {
        if (propertyValue == null) {
            return;
        }
        String exact = "-D" + propertyName;
        String prefix = "-D" + propertyName + "=";
        String value = propertyValue.isEmpty() ? exact : prefix + this.expandMacros(propertyValue);
        this.replaceOrAddAt(value, this.myParameters.size(), (Condition<? super String>)((Condition)o -> o.equals(exact) || o.startsWith(prefix)));
    }

    public void addNotEmptyProperty(@NotNull String propertyName, @Nullable String propertyValue) {
        if (StringUtil.isEmptyOrSpaces((String)propertyValue)) {
            return;
        }
        this.addProperty(propertyName, propertyValue);
    }

    public void replaceOrAppend(@NotNull String parameterPrefix, @NotNull String replacement) {
        this.replaceOrAddAt(this.expandMacros(replacement), this.myParameters.size(), (Condition<? super String>)((Condition)o -> o.startsWith(parameterPrefix)));
    }

    public void replaceOrPrepend(@NotNull String parameterPrefix, @NotNull String replacement) {
        this.replaceOrAddAt(this.expandMacros(replacement), 0, (Condition<? super String>)((Condition)o -> o.startsWith(parameterPrefix)));
    }

    private void replaceOrAddAt(@NotNull String replacement, int position, @NotNull Condition<? super String> existingCondition) {
        int index2 = this.indexOfParameter(existingCondition);
        boolean setNewValue = StringUtil.isNotEmpty((String)replacement);
        if (index2 > -1 && setNewValue) {
            this.myParameters.set(index2, replacement);
        } else if (index2 > -1) {
            this.myParameters.remove(index2);
        } else if (setNewValue) {
            this.myParameters.add(position, replacement);
        }
    }

    private int indexOfParameter(@NotNull Condition<? super String> condition) {
        return ContainerUtil.lastIndexOf(this.myParameters, condition);
    }

    public void set(int ind, @NotNull String value) {
        this.myParameters.set(ind, value);
    }

    public String get(int ind) {
        return this.myParameters.get(ind);
    }

    @Nullable
    public String getLast() {
        return this.myParameters.size() > 0 ? this.myParameters.get(this.myParameters.size() - 1) : null;
    }

    public void add(@NotNull String name, @NotNull String value) {
        this.myParameters.add(name);
        this.add(value);
    }

    public void addAll(String ... parameters) {
        this.addAll(Arrays.asList(parameters));
    }

    public void addAll(@NotNull List<String> parameters) {
        for (String parameter : parameters) {
            this.add(parameter);
        }
    }

    public ParametersList clone() {
        return this.copyTo(new ParametersList());
    }

    @NotNull
    ParametersList copyTo(@NotNull ParametersList target) {
        target.myParameters.addAll(this.myParameters);
        for (ParamsGroup group : this.myGroups) {
            target.myGroups.add(group.clone());
        }
        return target;
    }

    @NotNull
    public static String join(@NotNull List<String> parameters) {
        return ParametersListUtil.join(parameters);
    }

    @NotNull
    public static String join(String ... parameters) {
        return ParametersListUtil.join((String[])parameters);
    }

    @NotNull
    public static String[] parse(@NotNull String string) {
        return ParametersListUtil.parseToArray((String)string);
    }

    @NotNull
    public String expandMacros(@NotNull String text) {
        int start = text.indexOf("${");
        if (start < 0) {
            return text;
        }
        Map macroMap = (Map)this.myMacroMap.getValue();
        Matcher matcher = MACRO_PATTERN.matcher(text);
        StringBuilder sb = null;
        while (matcher.find(start)) {
            String value = (String)macroMap.get(matcher.group(1));
            if (value != null) {
                if (sb == null) {
                    sb = new StringBuilder(2 * text.length()).append(text, 0, matcher.start());
                } else {
                    sb.append(text, start, matcher.start());
                }
                sb.append(value);
                start = matcher.end();
                continue;
            }
            if (sb != null) {
                sb.append(text, start, matcher.start() + 2);
            }
            start = matcher.start() + 2;
        }
        return sb == null ? text : sb.append(text, start, text.length()).toString();
    }

    public static void setTestMacros(@Nullable Map<String, String> testMacros) {
        ourTestMacros = testMacros;
    }

    @NotNull
    private static Map<String, String> computeMacroMap() {
        Application application = ApplicationManager.getApplication();
        if (application == null || application.isUnitTestMode() && ourTestMacros != null) {
            return (Map)ObjectUtils.notNull(ourTestMacros, Collections.emptyMap());
        }
        THashMap map = ContainerUtil.newTroveMap((TObjectHashingStrategy)CaseInsensitiveStringHashingStrategy.INSTANCE);
        Map<String, String> pathMacros = PathMacros.getInstance().getUserMacros();
        if (!pathMacros.isEmpty()) {
            for (String name : pathMacros.keySet()) {
                ContainerUtil.putIfNotNull((Object)name, (Object)pathMacros.get(name), (Map)map);
            }
        }
        Map env = EnvironmentUtil.getEnvironmentMap();
        for (String name : env.keySet()) {
            ContainerUtil.putIfAbsent((Object)name, env.get(name), (Map)map);
        }
        return map;
    }

    public String toString() {
        return this.myParameters + (this.myGroups.isEmpty() ? "" : " and " + this.myGroups);
    }

    private static /* synthetic */ boolean lambda$defineProperty$1(String exact, String prefix, String o) {
        return o.equals(exact) || o.startsWith(prefix);
    }

    private static /* synthetic */ boolean lambda$getPropertyValue$0(String exact, String prefix, String o) {
        return o.equals(exact) || o.startsWith(prefix);
    }
}

