/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.configurations;

import com.intellij.execution.BeforeRunTask;
import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.execution.configurations.ConfigurationInfoProvider;
import com.intellij.execution.configurations.ConfigurationPerRunnerSettings;
import com.intellij.execution.configurations.ConfigurationType;
import com.intellij.execution.configurations.RunProfile;
import com.intellij.execution.configurations.RuntimeConfigurationException;
import com.intellij.execution.configurations.UnknownConfigurationType;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.runners.ProgramRunner;
import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.options.SettingsEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.PlatformUtils;
import com.intellij.util.xmlb.annotations.Transient;
import java.util.Collections;
import java.util.List;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface RunConfiguration
extends RunProfile,
Cloneable {
    public static final DataKey<RunConfiguration> DATA_KEY = DataKey.create("runtimeConfiguration");

    @NotNull
    default public ConfigurationType getType() {
        ConfigurationFactory factory = this.getFactory();
        return factory == null ? UnknownConfigurationType.getInstance() : factory.getType();
    }

    @Nullable
    public ConfigurationFactory getFactory();

    public void setName(String var1);

    @NotNull
    public SettingsEditor<? extends RunConfiguration> getConfigurationEditor();

    public Project getProject();

    @Nullable
    default public ConfigurationPerRunnerSettings createRunnerSettings(ConfigurationInfoProvider provider) {
        return null;
    }

    @Nullable
    default public SettingsEditor<ConfigurationPerRunnerSettings> getRunnerSettingsEditor(ProgramRunner runner) {
        return null;
    }

    public RunConfiguration clone();

    @Deprecated
    default public int getUniqueID() {
        return System.identityHashCode(this);
    }

    @Nullable
    default public String getId() {
        return null;
    }

    @Transient
    @NotNull
    default public String getPresentableType() {
        if (PlatformUtils.isPhpStorm()) {
            return " (" + StringUtil.first((String)this.getType().getDisplayName(), (int)10, (boolean)true) + ")";
        }
        return "";
    }

    default public boolean hideDisabledExecutorButtons() {
        return false;
    }

    default public void checkConfiguration() throws RuntimeConfigurationException {
    }

    default public void readExternal(@NotNull Element element) {
    }

    default public void writeExternal(@NotNull Element element) {
    }

    @NotNull
    default public List<BeforeRunTask<?>> getBeforeRunTasks() {
        return Collections.emptyList();
    }

    default public void setBeforeRunTasks(@NotNull List<BeforeRunTask<?>> value) {
    }

    default public boolean isAllowRunningInParallel() {
        return false;
    }

    default public void setAllowRunningInParallel(boolean value) {
    }

    default public RestartSingletonResult restartSingleton(@NotNull ExecutionEnvironment environment) {
        return RestartSingletonResult.ASK_AND_RESTART;
    }

    public static enum RestartSingletonResult {
        ASK_AND_RESTART,
        RESTART,
        NO_FURTHER_ACTION;

    }
}

