/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.dashboard;

import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.Key;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentManager;
import com.intellij.ui.content.ContentManagerAdapter;
import com.intellij.ui.content.ContentManagerEvent;
import com.intellij.ui.content.ContentUI;
import com.intellij.util.containers.EmptyIterator;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;

class PanelContentUI
implements ContentUI {
    private JPanel myPanel;
    private ContentManager myContentManager;

    PanelContentUI() {
    }

    @Override
    public JComponent getComponent() {
        this.initUI();
        return this.myPanel;
    }

    @Override
    public void setManager(@NotNull ContentManager manager) {
        assert (this.myContentManager == null);
        this.myContentManager = manager;
        manager.addContentManagerListener(new ContentManagerAdapter(){

            @Override
            public void selectionChanged(@NotNull ContentManagerEvent event) {
                PanelContentUI.this.initUI();
                if (ContentManagerEvent.ContentOperation.add == event.getOperation()) {
                    PanelContentUI.this.showContent(event.getContent());
                } else if (ContentManagerEvent.ContentOperation.remove == event.getOperation()) {
                    PanelContentUI.this.hideContent();
                }
            }
        });
    }

    private void initUI() {
        if (this.myPanel != null) {
            return;
        }
        this.myPanel = new JPanel(new BorderLayout());
        UIUtil.putClientProperty((JComponent)this.myPanel, (Key)UIUtil.NOT_IN_HIERARCHY_COMPONENTS, () -> {
            if (this.myContentManager == null || this.myContentManager.getContentCount() == 0) {
                return EmptyIterator.getInstance();
            }
            return JBIterable.of((Object[])this.myContentManager.getContents()).map(content -> {
                JComponent component = content.getComponent();
                return component != null && this.myPanel != component.getParent() ? component : null;
            }).filter(Conditions.notNull()).iterator();
        });
    }

    private void showContent(@NotNull Content content) {
        if (this.myPanel.getComponentCount() != 1 || this.myPanel.getComponent(0) != content.getComponent()) {
            this.myPanel.removeAll();
            this.myPanel.add((Component)content.getComponent(), "Center");
            this.myPanel.revalidate();
            this.myPanel.repaint();
        }
    }

    private void hideContent() {
        this.myPanel.removeAll();
        this.myPanel.revalidate();
        this.myPanel.repaint();
    }

    @Override
    public boolean isSingleSelection() {
        return true;
    }

    @Override
    public boolean isToSelectAddedContent() {
        return true;
    }

    @Override
    public boolean canBeEmptySelection() {
        return false;
    }

    @Override
    public void beforeDispose() {
    }

    @Override
    public boolean canChangeSelectionTo(@NotNull Content content, boolean implicit) {
        return true;
    }

    @Override
    @NotNull
    public String getCloseActionName() {
        return "";
    }

    @Override
    @NotNull
    public String getCloseAllButThisActionName() {
        return "";
    }

    @Override
    @NotNull
    public String getPreviousContentActionName() {
        return "";
    }

    @Override
    @NotNull
    public String getNextContentActionName() {
        return "";
    }

    public void dispose() {
        if (this.myPanel != null) {
            this.myPanel.removeAll();
        }
    }
}

