/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.filters;

import com.intellij.execution.filters.InputFilter;
import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.util.containers.ContainerUtilRt;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CompositeInputFilter
implements InputFilter {
    private static final Logger LOG = Logger.getInstance(CompositeInputFilter.class);
    private final List<InputFilterWrapper> myFilters = ContainerUtilRt.newArrayList();
    private final DumbService myDumbService;

    public CompositeInputFilter(@NotNull Project project) {
        this.myDumbService = DumbService.getInstance(project);
    }

    @Override
    @Nullable
    public List<Pair<String, ConsoleViewContentType>> applyFilter(@NotNull String text, @NotNull ConsoleViewContentType contentType) {
        boolean dumb = this.myDumbService.isDumb();
        for (InputFilterWrapper filter : this.myFilters) {
            if (dumb && !filter.isDumbAware) continue;
            long t0 = System.currentTimeMillis();
            List<Pair<String, ConsoleViewContentType>> result2 = filter.applyFilter(text, contentType);
            t0 = System.currentTimeMillis() - t0;
            if (t0 > 100L) {
                LOG.warn(filter.getClass().getSimpleName() + ".applyFilter() took " + t0 + " ms on '''" + text + "'''");
            }
            if (result2 == null) continue;
            return result2;
        }
        return null;
    }

    public void addFilter(@NotNull InputFilter filter) {
        InputFilterWrapper wrapper = new InputFilterWrapper(filter);
        this.myFilters.add(wrapper);
    }

    private static class InputFilterWrapper
    implements InputFilter {
        @NotNull
        private final InputFilter myOriginal;
        private boolean isBroken;
        private final boolean isDumbAware;

        InputFilterWrapper(@NotNull InputFilter original) {
            this.isDumbAware = DumbService.isDumbAware(original);
            this.myOriginal = original;
        }

        @Override
        @Nullable
        public List<Pair<String, ConsoleViewContentType>> applyFilter(@NotNull String text, @NotNull ConsoleViewContentType contentType) {
            if (!this.isBroken) {
                try {
                    return this.myOriginal.applyFilter(text, contentType);
                }
                catch (ProcessCanceledException ignored) {
                    ProgressManager.checkCanceled();
                }
                catch (Throwable e) {
                    this.isBroken = true;
                    LOG.error(e);
                }
            }
            return null;
        }
    }
}

