/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.filters;

import com.intellij.execution.filters.BrowserHyperlinkInfo;
import com.intellij.execution.filters.ConsoleFilterProviderEx;
import com.intellij.execution.filters.Filter;
import com.intellij.execution.filters.HyperlinkInfo;
import com.intellij.execution.filters.LazyFileHyperlinkInfo;
import com.intellij.ide.IdeBundle;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.io.URLUtil;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class UrlFilter
implements Filter,
DumbAware {
    private static final String FILE_URL_PROTOCOL = "file://";
    private final Project myProject;

    public UrlFilter() {
        this(null);
    }

    public UrlFilter(Project project) {
        this.myProject = project;
    }

    @Override
    @Nullable
    public Filter.Result applyFilter(@NotNull String line, int entireLength) {
        if (!URLUtil.canContainUrl((String)line)) {
            return null;
        }
        int textStartOffset = entireLength - line.length();
        Pattern pattern = line.contains(FILE_URL_PROTOCOL) ? URLUtil.FILE_URL_PATTERN : URLUtil.URL_PATTERN;
        Matcher m = pattern.matcher(line);
        Filter.ResultItem item = null;
        ArrayList<Filter.ResultItem> items = null;
        while (m.find()) {
            if (item == null) {
                item = new Filter.ResultItem(textStartOffset + m.start(), textStartOffset + m.end(), this.buildHyperlinkInfo(m.group()));
                continue;
            }
            if (items == null) {
                items = new ArrayList<Filter.ResultItem>(2);
                items.add(item);
            }
            items.add(new Filter.ResultItem(textStartOffset + m.start(), textStartOffset + m.end(), this.buildHyperlinkInfo(m.group())));
        }
        return items != null ? new Filter.Result(items) : (item != null ? new Filter.Result(item.getHighlightStartOffset(), item.getHighlightEndOffset(), item.getHyperlinkInfo()) : null);
    }

    @NotNull
    protected HyperlinkInfo buildHyperlinkInfo(@NotNull String url) {
        HyperlinkInfo fileHyperlinkInfo = this.buildFileHyperlinkInfo(url);
        return fileHyperlinkInfo != null ? fileHyperlinkInfo : new BrowserHyperlinkInfo(url);
    }

    @Nullable
    private HyperlinkInfo buildFileHyperlinkInfo(final @NotNull String url) {
        if (this.myProject != null && url.startsWith(FILE_URL_PROTOCOL)) {
            return new LazyFileHyperlinkInfo(this.myProject, StringUtil.trimStart((String)url, (String)FILE_URL_PROTOCOL), 0, 0){

                @Override
                @Nullable
                public OpenFileDescriptor getDescriptor() {
                    OpenFileDescriptor descriptor = super.getDescriptor();
                    if (descriptor == null) {
                        Messages.showErrorDialog(UrlFilter.this.myProject, "Cannot find file " + StringUtil.trimMiddle((String)url, (int)150), IdeBundle.message("title.cannot.open.file", new Object[0]));
                    }
                    return descriptor;
                }
            };
        }
        return null;
    }

    public static class UrlFilterProvider
    implements ConsoleFilterProviderEx {
        @Override
        @NotNull
        public Filter[] getDefaultFilters(@NotNull Project project, @NotNull GlobalSearchScope scope) {
            return new Filter[]{new UrlFilter(project)};
        }

        @Override
        @NotNull
        public Filter[] getDefaultFilters(@NotNull Project project) {
            return this.getDefaultFilters(project, GlobalSearchScope.allScope(project));
        }
    }
}

