/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.process;

import com.intellij.execution.process.ColoredOutputTypeRegistry;
import com.intellij.execution.process.ProcessOutputType;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AnsiEscapeDecoder {
    private static final char ESC_CHAR = '\u001b';
    private static final String CSI = "\u001b[";
    private static final String M_CSI = "m\u001b[";
    private final ColoredOutputTypeRegistry myColoredOutputTypeRegistry = ColoredOutputTypeRegistry.getInstance();
    private String myUnhandledStdout;
    private String myUnhandledStderr;
    private ProcessOutputType myCurrentStdoutOutputType;
    private ProcessOutputType myCurrentStderrOutputType;

    public void escapeText(@NotNull String text, @NotNull Key outputType, @NotNull ColoredTextAcceptor textAcceptor) {
        text = this.prependUnhandledText(text, outputType);
        int pos = 0;
        int findEscSeqFromIndex = 0;
        List<Pair<String, Key>> chunks = null;
        int unhandledSuffixLength = 0;
        while (true) {
            int escSeqBeginInd;
            if ((escSeqBeginInd = AnsiEscapeDecoder.findEscSeqBeginIndex(text, findEscSeqFromIndex)) < 0) {
                if (escSeqBeginInd >= -1) break;
                unhandledSuffixLength = AnsiEscapeDecoder.decodeUnhandledSuffixLength(escSeqBeginInd);
                break;
            }
            int escSeqEndInd = AnsiEscapeDecoder.findConsecutiveEscSequencesEndIndex(text, escSeqBeginInd);
            if (escSeqEndInd < 0) {
                if (escSeqEndInd == -1) {
                    findEscSeqFromIndex = escSeqBeginInd + CSI.length();
                    continue;
                }
                unhandledSuffixLength = AnsiEscapeDecoder.decodeUnhandledSuffixLength(escSeqEndInd);
                break;
            }
            assert (escSeqBeginInd <= escSeqEndInd);
            if (pos < escSeqBeginInd) {
                chunks = this.processTextChunk(chunks, text.substring(pos, escSeqBeginInd), outputType, textAcceptor);
            }
            findEscSeqFromIndex = pos = escSeqEndInd + 1;
            if (text.charAt(escSeqEndInd) != 'm') continue;
            String escSeq = text.substring(escSeqBeginInd, escSeqEndInd + 1);
            String colorAttribute = StringUtil.replace((String)escSeq, (String)M_CSI, (String)";");
            ProcessOutputType resultType = this.myColoredOutputTypeRegistry.getOutputType(colorAttribute, outputType);
            if (resultType.isStdout()) {
                this.myCurrentStdoutOutputType = resultType;
                continue;
            }
            if (!resultType.isStderr()) continue;
            this.myCurrentStderrOutputType = resultType;
        }
        if (pos < text.length() - unhandledSuffixLength) {
            chunks = this.processTextChunk(chunks, text.substring(pos, text.length() - unhandledSuffixLength), outputType, textAcceptor);
        }
        this.updateUnhandledSuffix(text, outputType, unhandledSuffixLength);
        if (chunks != null && textAcceptor instanceof ColoredChunksAcceptor) {
            ((ColoredChunksAcceptor)textAcceptor).coloredChunksAvailable(chunks);
        }
    }

    private void updateUnhandledSuffix(@NotNull String text, @NotNull Key outputType, int unhandledSuffixLength) {
        String unhandledSuffix;
        String string = unhandledSuffix = unhandledSuffixLength > 0 ? text.substring(text.length() - unhandledSuffixLength) : null;
        if (ProcessOutputType.isStdout((Key)outputType)) {
            this.myUnhandledStdout = unhandledSuffix;
        } else if (ProcessOutputType.isStderr((Key)outputType)) {
            this.myUnhandledStderr = unhandledSuffix;
        }
    }

    @NotNull
    private String prependUnhandledText(@NotNull String text, @NotNull Key outputType) {
        String prevUnhandledText = null;
        if (ProcessOutputType.isStdout((Key)outputType)) {
            prevUnhandledText = this.myUnhandledStdout;
            this.myUnhandledStdout = null;
        } else if (ProcessOutputType.isStderr((Key)outputType)) {
            prevUnhandledText = this.myUnhandledStderr;
            this.myUnhandledStderr = null;
        }
        return prevUnhandledText != null ? prevUnhandledText + text : text;
    }

    private static int findEscSeqBeginIndex(@NotNull String text, int fromIndex) {
        int ind = text.indexOf(CSI.charAt(0), fromIndex);
        if (ind == -1) {
            return -1;
        }
        if (ind == text.length() - 1) {
            return AnsiEscapeDecoder.encodeUnhandledSuffixLength(text, ind);
        }
        return text.charAt(ind + 1) == CSI.charAt(1) ? ind : -1;
    }

    private static int findConsecutiveEscSequencesEndIndex(@NotNull String text, int firstEscSeqBeginInd) {
        int escSeqEndInd;
        int escSeqBeginInd = firstEscSeqBeginInd;
        int lastMatchedColorEscSeqEndInd = -1;
        while ((escSeqEndInd = AnsiEscapeDecoder.findEscSeqEndIndex(text, escSeqBeginInd)) >= 0) {
            if (text.charAt(escSeqEndInd) != 'm') {
                return lastMatchedColorEscSeqEndInd > 0 ? lastMatchedColorEscSeqEndInd : escSeqEndInd;
            }
            escSeqBeginInd = escSeqEndInd + 1;
            lastMatchedColorEscSeqEndInd = escSeqEndInd;
            if (escSeqEndInd + 1 >= text.length()) {
                return AnsiEscapeDecoder.encodeUnhandledSuffixLength(text, firstEscSeqBeginInd);
            }
            if (text.charAt(escSeqEndInd + 1) != CSI.charAt(0)) break;
            if (escSeqEndInd + 2 >= text.length()) {
                return AnsiEscapeDecoder.encodeUnhandledSuffixLength(text, firstEscSeqBeginInd);
            }
            if (text.charAt(escSeqEndInd + 2) == CSI.charAt(1)) continue;
        }
        if (escSeqEndInd < -1) {
            return AnsiEscapeDecoder.encodeUnhandledSuffixLength(text, firstEscSeqBeginInd);
        }
        return lastMatchedColorEscSeqEndInd;
    }

    private static int findEscSeqEndIndex(@NotNull String text, int escSeqBeginInd) {
        char ch;
        int parameterEndInd;
        for (parameterEndInd = escSeqBeginInd + CSI.length(); parameterEndInd < text.length() && '0' <= (ch = text.charAt(parameterEndInd)) && ch <= '?'; ++parameterEndInd) {
        }
        while (parameterEndInd < text.length() && ' ' <= (ch = text.charAt(parameterEndInd)) && ch <= '/') {
            ++parameterEndInd;
        }
        if (parameterEndInd == text.length()) {
            return AnsiEscapeDecoder.encodeUnhandledSuffixLength(text, escSeqBeginInd);
        }
        char lastChar = text.charAt(parameterEndInd);
        return '@' <= lastChar && lastChar <= '~' ? parameterEndInd : -1;
    }

    private static int encodeUnhandledSuffixLength(@NotNull String text, int suffixStartInd) {
        return -1 - (text.length() - suffixStartInd);
    }

    private static int decodeUnhandledSuffixLength(int encodedUnhandledSuffixLength) {
        if (encodedUnhandledSuffixLength >= -1) {
            throw new AssertionError();
        }
        return -encodedUnhandledSuffixLength - 1;
    }

    @Nullable
    private List<Pair<String, Key>> processTextChunk(@Nullable List<Pair<String, Key>> buffer, @NotNull String text, @NotNull Key outputType, @NotNull ColoredTextAcceptor textAcceptor) {
        Key attributes = this.getCurrentOutputAttributes(outputType);
        if (textAcceptor instanceof ColoredChunksAcceptor) {
            if (buffer == null) {
                buffer = ContainerUtil.newArrayListWithCapacity((int)1);
            }
            buffer.add(Pair.create((Object)text, (Object)attributes));
        } else {
            textAcceptor.coloredTextAvailable(text, attributes);
        }
        return buffer;
    }

    @NotNull
    protected Key getCurrentOutputAttributes(@NotNull Key outputType) {
        if (ProcessOutputType.isStdout((Key)outputType)) {
            return (Key)ObjectUtils.notNull((Object)this.myCurrentStdoutOutputType, (Object)outputType);
        }
        if (ProcessOutputType.isStderr((Key)outputType)) {
            return (Key)ObjectUtils.notNull((Object)this.myCurrentStderrOutputType, (Object)outputType);
        }
        return outputType;
    }

    @FunctionalInterface
    public static interface ColoredTextAcceptor {
        public void coloredTextAvailable(@NotNull String var1, @NotNull Key var2);
    }

    public static interface ColoredChunksAcceptor
    extends ColoredTextAcceptor {
        public void coloredChunksAvailable(@NotNull List<Pair<String, Key>> var1);
    }
}

